package EnsEMBL::MaizeBlast::SiteDefs;
use strict;

# These are the gramene-specific edits to the main Ensembl SiteDefs.pm file
sub update_conf {
  warn( "===> ", __PACKAGE__, "->update_conf\n" );
  my $DEVELOPMENT_SITE       = 1;    #acorn or filetta
  
  $SiteDefs::ENSEMBL_PORT         = $DEVELOPMENT_SITE ? 8028 : 8029;
  $SiteDefs::ENSEMBL_PROXY_PORT   = 80; # Port used for self-referential URLs:
  $SiteDefs::ENSEMBL_USER         = 'nobody';     
  $SiteDefs::ENSEMBL_GROUP        = getgrgid($));

  $SiteDefs::ENSEMBL_SERVERADMIN  = 'webmaster@maizesequence.org';
  $SiteDefs::ENSEMBL_SERVERNAME   = ($DEVELOPMENT_SITE ? 
                                     'dev' : 'www') . '.maizesequence.org';
  $SiteDefs::ENSEMBL_MAIL_ERRORS  = ($DEVELOPMENT_SITE ? 0 : 1);
  $SiteDefs::ENSEMBL_ERRORS_TO    = 'webmaster@maizesequence.org';

  #----------
  # tmp dirs; tweak for proxy
  $SiteDefs::ENSEMBL_TMP_URL       = '/BlastView/tmp';
  $SiteDefs::ENSEMBL_TMP_URL_IMG   = '/BlastView/img-tmp';
  $SiteDefs::ENSEMBL_TMP_URL_CACHE = '/BlastView/img-cache';

  $SiteDefs::ENSEMBL_PERL_SPECIES  = 'Zea_mays2';
}

1;
