#!/usr/local/bin/perl
###############################################################################
#   
#   Name:           EnsEMBL::HTML::StaticTemplates.pm
#   
#   Description:    Populates templates for static content.
#                   Run at server startup
#
###############################################################################

package EnsEMBL::HTML::StaticTemplates;
use strict;
use warnings;
no warnings "uninitialized";

use SpeciesDefs;
use SiteDefs;

use Exporter();

use vars qw( @ISA @EXPORT $SPECIES_DEFS );
@ISA = qw(Exporter);

@EXPORT = qw( createSearchBox
	      createSpeciesButtons
	      createGraphicsButtons
	      createSiteMap
	      createCSS );

$SPECIES_DEFS = SpeciesDefs->new();

#----------------------------------------------------------------------
sub createSearchBox{
  local $/ = undef;

  my %features = ();
  foreach my $species ( $SPECIES_DEFS->valid_species ) {
    next if $SPECIES_DEFS->get_config($species,'GENERATE_HOME_PAGE') ne 'yes';
    my %hash = 
      (
       'species'    => $species,
       'commonname' => $SPECIES_DEFS->get_config($species,'SPECIES_COMMON_NAME'),
      );
    
    my $chr_ref = $SPECIES_DEFS->get_config($species,'ENSEMBL_CHROMOSOMES');
    if( ref( $chr_ref ) eq 'ARRAY' ){
      my $tmpl = qq(<option value="%s">%s</option>);
      $hash{'chrlist'} = join( "\n", map{ sprintf($tmpl,$_,$_) } @$chr_ref );
    }
    
    my $idx_ref = $SPECIES_DEFS->get_config( $species,'ENSEMBL_SEARCH_IDXS');
    if( ref( $idx_ref ) eq 'ARRAY' ){
      my $tmpl = qq(<option value="%s">%s</option>);
      $hash{'featurelist'} = join( "\n", 
				   map{ sprintf($tmpl,$_,$_) } 
				   sort @$idx_ref );
      
      foreach( @$idx_ref ){ $features{$_} = 1 }
    }
    
    my $dir     = $SiteDefs::ENSEMBL_HTDOCS_DIRS[0]."/$species/homepage_SSI";
    my $infile  = "$dir/searchtable.tmpl";
    my $outfile = "$dir/searchtable.html";
    
    open( I, $infile ) || next;
    my $TEMPLATE = <I>;
    close I;
    $TEMPLATE =~s/\[\[([a-z]+)\]\]/$hash{$1}/eg;
    open( O, ">$outfile" ) || next;
    print O $TEMPLATE;
    close O;
  }
  
  my %hash;
  $hash{'featurelist'} = join( "\n", 
			       map { qq(<option value="$_">$_</option>) } 
			       sort keys %features ); 
  
  my $dir     = $SiteDefs::ENSEMBL_HTDOCS_DIRS[0]."/homepage_SSI";
  my $infile  = "$dir/searchtable.tmpl";
  my $outfile = "$dir/searchtable.html";

  if( open( I, $infile ) ){
    my $TEMPLATE = <I>;
    close I;
    if(open O, ">$outfile") {
      $TEMPLATE =~s/\[\[([a-z]+)\]\]/$hash{$1}/eg;
      print O $TEMPLATE;
      close O;
    }
  }
}
#----------------------------------------------------------------------
sub createSpeciesButtons{
  local $/ = undef;

  my $htdocs_dir = $SiteDefs::ENSEMBL_HTDOCS_DIRS[0];
  my @species = $SPECIES_DEFS->valid_species;
  foreach my $species ( @species ) {
    next if $SPECIES_DEFS->get_config($species,'GENERATE_HOME_PAGE') ne 'yes';
    
    my $buttons = join "\n", map
      {
	qq(<a href="/$_->[1]/" onMouseOut="MM_swapImgRestore()"
	   onMouseOver="MM_swapImage('$_->[3]','','/gfx/rollovers/$_->[3]1_do.gif',1)"><img name="$_->[3]"
	   border="0" src="/gfx/rollovers/$_->[3]1_up.gif" width="90" height="20" alt="Ensembl $_->[2]"></a>)
      } map
	  {
	    [ ucfirst($_), 
	      $_, 
	      $SPECIES_DEFS->get_config($_,'SPECIES_COMMON_NAME'),
	      lc($SPECIES_DEFS->get_config($_,'SPECIES_COMMON_NAME')) ]
	  } grep
	    {
	      ($species ne $_) && ($_ ne 'Multi')
	    } sort @species;
      
    next unless -e "$htdocs_dir/$species/homepage_SSI/species.tmpl";
    open I, "$htdocs_dir/$species/homepage_SSI/species.tmpl" || next;
    my $TEMPLATE = <I>;
    close I;
    $TEMPLATE =~s/\[\[buttons\]\]/$buttons/eg;
    open( O, ">$htdocs_dir/$species/homepage_SSI/species.html" ) || next;
    print O $TEMPLATE;
    close O;
  }
}

#----------------------------------------------------------------------
sub createGraphicsButtons{
  my $species = $SiteDefs::ENSEMBL_PERL_SPECIES;
  my $colours = $SPECIES_DEFS->get_config($species, 'ENSEMBL_COLOURS');
  my $map0 = quotemeta(pack('H6','ffdf27'));
  my $col0 = pack( 'H6', $colours->{'background0'});
  my $map1 = quotemeta(pack('H6','ffffe7'));
  my $col1 = pack( 'H6', $colours->{'background1'});
  my $map2 = quotemeta(pack('H6','ffffdd'));
  my $col2 = pack( 'H6', $colours->{'background2'});
  my $map3 = quotemeta(pack('H6','ffffcc'));
  my $col3 = pack( 'H6', $colours->{'background3'});
  my $map4 = quotemeta(pack('H6','999900'));
  my $col4 = pack( 'H6', $colours->{'background4'});
  foreach my $dir (qw(buttons dd_menus) ) {
    my $D = $SiteDefs::ENSEMBL_HTDOCS_DIRS[0]."/gfx/$dir";
    opendir(DIR, "$D/templates") or next;
    foreach( readdir(DIR) ) {
      my $F = "$D/templates/$_";
      next unless -f $F;
      my $l = -s $F;
      open I,$F or next;
      my $gif;
      read I,$gif,$l;
      $gif =~s/$map1/$col1/;
      $gif =~s/$map2/$col2/;
      $gif =~s/$map3/$col3/;
      $gif =~s/$map4/$col4/;
      $gif =~s/$map0/$col0/;
      open( O, ">$D/$_" ) || next;
      binmode(O);
      print O $gif;
      close O;
    }
  }
}
#----------------------------------------------------------------------
sub createSiteMap{
  local $/ = undef();
  foreach my $species( $SPECIES_DEFS->valid_species ) {
    next if $SPECIES_DEFS->get_config($species,'GENERATE_HOME_PAGE') ne 'yes';

    my %examples;
    my $links_ref = $SPECIES_DEFS->get_config( $species, 'SEARCH_LINKS' );
    if( ref( $links_ref ) eq 'HASH' ){
      foreach my $KEY( sort keys %$links_ref ) {
	my $VAL = $links_ref->{$KEY};
	if($KEY=~/(.*?)1_URL/) {
	  $examples{lc($1)} = $VAL;
	}
      }
    }
    if( $SPECIES_DEFS->get_config( $species, 'CYTOVIEW_ENABLED' ) ){
      $examples{'cytoview'} = $examples{'contigview'};
      $examples{'cytoview'} =~ s/contigview/cytoview/;
    }

    my $dir     = $SiteDefs::ENSEMBL_HTDOCS_DIRS[0]."/$species/sitemap";
    my $infile  = "$dir/sitemap.tmpl";
    my $outfile = "$dir/sitemap.html";

    open( I, $infile ) || next;
    my $TEMPLATE = <I>;
    close I;
    $TEMPLATE =~s/\[\[SPECIES\]\]/$species/eg;
    $TEMPLATE =~s/\[\[LINK:(\w+)\]\]/$examples{$1} ? 
      (qq(href="\/$species\/$examples{$1}" alt=").ucfirst($1).qq(")) : 
	qq(nohref alt="[not implemented in this species]") /eg;
    open( O, ">$outfile" ) || next;
    print O $TEMPLATE;
    close O;
  }
}

#----------------------------------------------------------------------
sub createCSS{
  local $/ = undef;

  my $sp = $SiteDefs::ENSEMBL_PERL_SPECIES;  
  if( ! $SPECIES_DEFS->valid_species( $sp ) ){
    $sp = 'Multi'; # Hack for standalone mart
  }
  my $colours = $SPECIES_DEFS->get_config( $sp, 'ENSEMBL_COLOURS' );
  my $htdocs_dir = $SiteDefs::ENSEMBL_HTDOCS_DIRS[0];

## Non Mac stylesheet
  my $TEMPLATE = '';
  if( open( I, "$htdocs_dir/EnsEMBL.css-tmpl" ) ){
    $TEMPLATE = <I>;
    close I;
  } else { warn( "Cannot open $htdocs_dir/EnsEMBL.css-tmpl: $!" ) }
  my $T2 = $TEMPLATE;
  $TEMPLATE =~s/###size(\d+)###/$1/g;
  $TEMPLATE =~s/###(\w+)###/$colours->{$1}/eg;
  if( open( O, ">$htdocs_dir/EnsEMBL.css" ) ){
    print O  $TEMPLATE;
    close O;
  } else { warn( "Cannot open $htdocs_dir/EnsEMBL.css: $!" ) }

## Mac stylesheet
  $T2 =~s/###size(\d+)###/(2+$1)/ge;
  $T2 =~s/###(\w+)###/$colours->{$1}/eg;
  if( open( O, ">$htdocs_dir/EnsEMBL-mac.css" ) ){
    print O  $T2;
    close O;
  } else { warn( "Cannot open $htdocs_dir/EnsEMBL-mac.css: $!" ) }

## Javascript zmenus...
  if( open(  I, "$htdocs_dir/js/zmenu.js-tmpl" ) ){
    $TEMPLATE = <I>;
    $TEMPLATE =~s/###size(\d+)###/$1/g;
    $TEMPLATE =~s/###(\w+)###/$colours->{$1}/eg;

    if( open( O, ">$htdocs_dir/js/zmenu.js" ) ){
      print O $TEMPLATE;
      close O;
    } else { warn( "Cannot open $htdocs_dir/js/zmenu.js: $!" ) }
  } else { warn( "Cannot open $htdocs_dir/js/zmenu.js-tmpl: $!" ) }
}

#----------------------------------------------------------------------
1;
