package Bio::EnsEMBL::GlyphSet::repeat_lite;
use strict;
use vars qw(@ISA);
use Bio::EnsEMBL::GlyphSet_simple;

@ISA = qw( Bio::EnsEMBL::GlyphSet_simple );

sub my_label { return "Rice_TE"; }

sub features {
  my $self = shift;
  my @features = sort { $a->seq_region_start <=> $b->seq_region_start } @{$self->{'container'}->get_all_RepeatFeatures()};
  return \@features;
}

sub zmenu {
  my( $self, $f ) = @_;

  my $Config=$self->{'config'};
  my $linkout=$Config->get('repeat_lite','linkout');

  my($start,$end) = $self->slice2sr( $f->start(), $f->end() );
  my $len   = $end - $start + 1;

  my %link={};
  if(ref $f->analysis) {
      my $logic_name=$f->analysis->logic_name;
      my $link_url=$linkout->{$logic_name} || '';
     %link=( $logic_name => $link_url );
  }
#  may want to do something like this:
#  $link_url=~s/CONSENSUS_NAME/$f->repeat_consensus()->name()/ge;
#  $link_url=~s/HIT_ID/$f->{'hid'}/ge;

  ### Possibly should not use $f->repeat_consensus->name.... was f->{'hid'}
  return {
	  'caption' => $f->repeat_consensus()->name(),
	  %link,
	  "bp: $start-$end" => '',
	  "length: $len"    => ''
    }
}

1;
__END__

