package Bio::EnsEMBL::GlyphSet::generic_synteny;
use strict;
use vars qw(@ISA);
use Bio::EnsEMBL::GlyphSet_simple;
@ISA = qw(Bio::EnsEMBL::GlyphSet_simple);
use Bio::EnsEMBL::Feature;

sub my_label { return $_[0]->my_config('label'); }

sub help_link { return 'compara_synteny'; }

sub features {
  my ($self) = @_;
  my $species = $self->my_config('species');
  (my $species_2 = $species) =~ s/_/ /;
  my $T = $self->{'container'}->get_all_compara_Syntenies( $species_2, "SYNTENY");
  my $offset = $self->{'container'}->start - 1;
  my @RET;
  foreach my $argh (@$T) {
    my ($main_dfr, $other_dfr);
    foreach my $dfr (@{$argh->children}) {
      if($dfr->dnafrag->genome_db->name eq $species_2) {
        $other_dfr = $dfr;
      } else {
        $main_dfr = $dfr;
      }
    }
    my $f = Bio::EnsEMBL::Feature->new(
      -start   => $main_dfr->dnafrag_start - $offset,
      -end     => $main_dfr->dnafrag_end   - $offset,
      -strand  => $main_dfr->dnafrag_strand,
      -seqname => $_,
    );
    $f->{'hit_chr_name'}  = $other_dfr->dnafrag->name;
    $f->{'hit_chr_start'} = $other_dfr->dnafrag_start;
    $f->{'hit_chr_end'}   = $other_dfr->dnafrag_end;
    $f->{'chr_start'}     = $main_dfr->dnafrag_start;
    $f->{'chr_end'}       = $main_dfr->dnafrag_end;
    $f->{'rel_ori'}       = $main_dfr->dnafrag_strand * $other_dfr->dnafrag_strand;
    push @RET, $f;
    $argh->release_tree;
  }
  return \@RET;
}

sub colour {
  my ($self, $f) = @_;
  unless(exists $self->{'config'}{'pool'}) {
    $self->{'config'}{'pool'} = $self->{'config'}->colourmap->{'colour_sets'}{'synteny'};
    $self->{'config'}{'ptr'}  = 0;
  }
  $self->{'config'}{'_synteny_colours'}||={};
  my $return = $self->{'config'}{'_synteny_colours'}{ $f->{'hit_chr_name'} };
  unless( $return ) {
    $return = $self->{'config'}{'_synteny_colours'}{$f->{'hit_chr_name'}} = $self->{'config'}{'pool'}[ ($self->{'config'}{'ptr'}++)%@{$self->{'config'}{'pool'}} ];
  } 
  return $return, $return;
}

## Return the image label and the position of the label
## (overlaid means that it is placed in the centre of the
## feature.

sub image_label {
  my ($self, $f ) = @_;
  return ( $f->{'rel_ori'}<0 ? '<' : '' ).
         $f->{'hit_chr_name'}.
         ( $f->{'rel_ori'}<0 ? '' : '>' ) , 'under';
}

sub href { 
  my ($self, $f ) = @_;
  my $ospecies = $self->my_config('species');
  return "/$ospecies/cytoview?chr=$f->{'hit_chr_name'};".
      "vc_start=$f->{'hit_chr_start'};vc_end=$f->{'hit_chr_end'}";
}

## Create the zmenu...
## Include each accession id separately

sub zmenu {
  my ($self, $f ) = @_;
  my $species = $ENV{ENSEMBL_SPECIES};
  my $ospecies = $self->my_config('species');
  my $zmenu = { 
    'caption' => "$f->{'hit_chr_name'} $f->{'hit_chr_start'}-$f->{'hit_chr_end'}",
    "01:Jump to $ospecies" => $self->href($f),
    '04:bps: '.$f->{'chr_start'}."-".$f->{'chr_end'} => '',
    '05:Orientation:'.($f->{'rel_ori'}<0 ? ' reverse' : ' same')  => '',
  };

  # Hacky Gramene stuff for CMap link
  my $map1       = $f->{'chr_name'};
  my $map1_start = $f->{'chr_start'};
  my $map1_end   = $f->{'chr_end'};
  my $map2       = $f->{'hit_chr_name'};
  my $map2_start = $f->{'hit_chr_start'};
  my $map2_end   = $f->{'hit_chr_end'};

  my $slice;
  if( $species eq 'Zea_mays' ){
    $slice = $self->{'container'}->seq_region_Slice;
    $slice = $slice->sub_Slice($f->{'chr_start'}, $f->{'chr_end'});
  } elsif( $ospecies eq 'Zea_mays' ){
    my $sa = Bio::EnsEMBL::Registry->get_adaptor($ospecies,'core','Slice');
    $slice = $sa->fetch_by_region('',$map2,$map2_start,$map2_end);
  } 
  if( $slice ){
    my $proj;
    eval{ $proj = ${$slice->project('fpc')}[0] };
    if( $@ ){ die $@ unless $@ =~ /Cannot project to unknown coordinate sys/ }
    if( $proj ){
      my $band_to_bp = 4096; 
      $slice = $proj->to_Slice;
      my $map = $slice->seq_region_name; 
      my $map_start = $slice->start / $band_to_bp;
      my $map_end   = $slice->end   / $band_to_bp;
      if( $species eq 'Zea_mays' ){ 
        ($map1,$map1_start,$map1_end) = ($map,$map_start,$map_end);
        $zmenu->{"03: $species: $map1 $map1_start-$map1_end"} = '';
      } elsif( $ospecies eq 'Zea_mays' ){
        ($map2,$map2_start,$map2_end) = ($map,$map_start,$map_end);
        $zmenu->{"03: $ospecies: $map2 $map2_start-$map2_end"} = '';
      }
    }
  }


  my $link_ref = "CMAP_SYNTENY_".uc($ospecies);
  $zmenu->{"02:Jump to CMap (comparative)"} = 
      "r?d=$link_ref&MAP1=$map1&MAP1_START=$map1_start&MAP1_END=$map1_end&".
      "MAP2=$map2&MAP2_START=$map2_start&MAP2_STOP=$map2_end";

  return $zmenu;
}

1;
