package EnsEMBL::GrmBlast::SiteDefs;
use strict;

# These are the gramene-specific edits to the main Ensembl SiteDefs.pm file
sub update_conf {
  warn( "===> ", __PACKAGE__, "->update_conf\n" );

  my $DEVELOPMENT_SITE       = 1;    #acorn or filetta
  
  $SiteDefs::ENSEMBL_PORT         = $DEVELOPMENT_SITE ? 8018 : 8019;
  $SiteDefs::ENSEMBL_PROXY_PORT   = 80; # Port used for self-referential URLs:
  $SiteDefs::ENSEMBL_USER         = 'nobody';     
  $SiteDefs::ENSEMBL_GROUP        = getgrgid($));

  $SiteDefs::ENSEMBL_SERVERADMIN  = 'ensembl&#064;gramene.org';
  #$SiteDefs::ENSEMBL_SERVERNAME  = 'dev.gramene.org';
  $SiteDefs::ENSEMBL_SERVERNAME   = ($DEVELOPMENT_SITE ? 
                                     'dev' : 'www') . '.gramene.org';
  $SiteDefs::ENSEMBL_MAIL_ERRORS  = 0;
  $SiteDefs::ENSEMBL_ERRORS_TO    = 'ensembl@gramene.org';

#  $SiteDefs::ENSEMBL_TMP_DIR_BLAST          = $SiteDefs::ENSEMBL_SERVERROOT."/blastqueue";
#  $SiteDefs::ENSEMBL_BLASTSCRIPT            = $SiteDefs::ENSEMBL_SERVERROOT."/utils/runblast.pl";

  $SiteDefs::ENSEMBL_USERDB_NAME  = 'ensembl_web_user_db';
  $SiteDefs::ENSEMBL_USERDB_USER  = 'gramene_web';
  $SiteDefs::ENSEMBL_USERDB_HOST  = 'acorn.cshl.edu';
  $SiteDefs::ENSEMBL_USERDB_PORT  =  3306;
  $SiteDefs::ENSEMBL_USERDB_PASS  = 'gram3n3';


  $SiteDefs::ENSEMBL_DEBUG_FLAGS  = 24;
  $SiteDefs::ENSEMBL_LONGPROCESS_MINTIME    = 10;

#  unshift( @SiteDefs::ENSEMBL_LIB_DIRS, 
#           $SiteDefs::ENSEMBL_SERVERROOT."/public-plugins/gramene/modules");
  unshift( @SiteDefs::ENSEMBL_LIB_DIRS, 
           $SiteDefs::ENSEMBL_SERVERROOT."/gramene-live/lib/perl");
  unshift( @SiteDefs::ENSEMBL_HTDOCS_DIRS,
           $SiteDefs::ENSEMBL_SERVERROOT."/gramene-live/html" );

  #----------
  # Logging
  my $LOG_ROOT = $SiteDefs::ENSEMBL_SERVERROOT."/logs";
  $SiteDefs::ENSEMBL_PIDFILE   = "$LOG_ROOT/httpd.pid";
  $SiteDefs::ENSEMBL_ERRORLOG  = "$LOG_ROOT/error.log";
  $SiteDefs::ENSEMBL_CUSTOMLOG = "$LOG_ROOT/access.log combined";

  #----------
  # tmp dirs; tweak for proxy
  $SiteDefs::ENSEMBL_TMP_URL       = '/BlastView/tmp';
  $SiteDefs::ENSEMBL_TMP_URL_IMG   = '/BlastView/img-tmp';
  $SiteDefs::ENSEMBL_TMP_URL_CACHE = '/BlastView/img-cache';

  #----------
  # Species stuff
  $SiteDefs::ENSEMBL_PERL_SPECIES = 'Rice'; # Default species
  %SiteDefs::__species_aliases =
    (
     # one of the values has to be the SPECIES_CODE 
     # defined in the species.ini file
     # those are 'os', 'zm' 'zm2' 'at'
     'Aegilops'           => [('ae')],
     'Arabidopsis'        => [('at', 
                               #'arabidopsis_thaliana',  
                               'weed', )],
     'Avena'              => [('av',                #code 
                               'avena_sativa',      #species
                               'oat')],             #common
     'Barley'             => [('ho',                #code
                               'hordeum',           #genus
                               'hordeum_vulgare')], #species
     'Maize'              => [('ze', 
                               'zea',
                               'zea_mays',
                               'zea_mays2')],
     'Millet'             => [('mi', 
                               'seteria',
                               'foxtail_millet',
                               'setaria_italica')],
#     'Pennisetum'         => [('pm',
#                               'pearl_millet')],
     'Poaceae'            => [('gr', 
                               'grass')],
     'Rice'               => [(#'os', 
                               #'oryza_sativa',          
                               'rice',
                               'japonica',
                               'homo_sapiens')],
     'Rice_alta'          => [('oa', 
                               'oryza_alta',            
                               'alta',)],
     'Rice_australiensis' => [('ou', 
                               'oryza_australiensis',   
                               'australiensis',)],
     'Rice_brachyantha'   => [('ob', 
                               'oryza_brachyantha',     
                               'brachyantha',)],
     'Rice_glaberrima'    => [('og', 
                               'oryza_glaberrima',      
                               'glaberrima',)],
     'Rice_indica'        => [('oi', 
                               'indica',)],
     'Rice_nivara'        => [('on', 
                               'oryza_nivara',          
                               'nivara',)],
     'Rice_punctata'      => [('op', 
                               'oryza_punctata',        
                               'punctata',)],
     'Rice_rufipogon'     => [('or', 
                               'oryza_rufipogon',       
                               'rufipogon',)],
     'Secale'             => [('se', 
                               'secale_cereale',        
                               'rye')],
     'Sorghum'            => [('so', 
                               'sorghum_bicolor',       
                               'sorghum',)],
     'Sugarcane'          => [('su', 
                               'saccharum_officinarum', 
                               'sugarcane',)],
     'Wheat'              => [('wh', 
                               'triticum_aestivum',     
                               'wheat',)],
     'Oryza_sativa'        => [('os')],
     'Zea_mays2'           => [('zm2')],
     'Arabidopsis_thaliana'=> [('at2')],
     );

  $SiteDefs::ENSEMBL_NOMART ++; #Turn off mart for now

  #--------------------------------------------------
  # Gramene-specific stuff
  # Get the PerlSetVar configuration from main gramene httpd.conf
  # TODO: split this out into a shared text file, or even something that 
  # can be "eval'ed" straight into perl
  my $gramene_confdir = "$SiteDefs::ENSEMBL_SERVERROOT/gramene-live/conf";
  my $gramene_httpd   = $gramene_confdir.'/httpd.conf';
  open( HTTPD, $gramene_httpd );
  foreach(<HTTPD>){
    chomp;
    if(/^PerlSetVar/){
      my( $directive, $key, $value ) = split(/\s+/, $_, 3);
      $SiteDefs::PerlSetVar{$key} = $value;
    }
  }
  $SiteDefs::PerlSetVar{NavConf} = $gramene_confdir."/navbar.conf";

}

1;
