package EnsWeb;

#
# Things we need for the web site. A sort of grab bag at the moment
#

use strict;
use Apache::Constants qw(:response :methods :http);
use Apache 'exit';
use Sys::Hostname;
use EnsEMBL::Web::SpeciesDefs;
use Carp qw(cluck);

#############################
# Load the species defs file
#############################
use vars qw($species_defs);

$species_defs = new EnsEMBL::Web::SpeciesDefs();
&ensembl_exception("Unable to retrieve species defs") unless $species_defs->retrieve();

use EnsEMBL::HTML::Page; # Used for deprecated calls
use Sanger::Graphics::JSTools;
use DBI;

use Data::Dumper;


use vars qw/@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS/;
require  Exporter;
@ISA     = qw(Exporter);
@EXPORT  = qw( species_defs initialise ensembl_warning ensembl_exception ensembl_exit get_unique_id);

my $hostname = $species_defs->ENSEMBL_SERVER; 

sub species_defs { return $species_defs; }

sub commify { local $_ = reverse $_[0]; s/(\d\d\d)(?=\d)(?!\d*\.)/$1,/g; return scalar reverse $_; }

#### Deprecated

sub initialise {
  cluck( 'Deprecated' );
#    undef($ENV{'NO_JS_MENUS'});
}

sub ensembl_exit {
  cluck( 'Deprecated: use EnsEMBL::HTML::Page::ensembl_exit' );
  return EnsEMBL::HTML::Page::ensembl_exit();
}

sub ensembl_exception{
  cluck( 'Deprecated: use EnsEMBL::HTML::Page::ensembl_exception' );
  return EnsEMBL::HTML::Page::ensembl_exception();
}

sub ensembl_warning{
  cluck( 'Deprecated: use EnsEMBL::HTML::Page::ensembl_warning' );
  return EnsEMBL::HTML::Page::ensembl_warning();
}

sub http_header{
  cluck( 'Deprecated: use EnsEMBL::HTML::Page::ensembl_http_header' );
  return EnsEMBL::HTML::Page::ensembl_http_header();
}

sub make_cgi_header{
  cluck( 'Deprecated: use EnsEMBL::HTML::Page::ensembl_page_header' );
  return EnsEMBL::HTML::Page::ensembl_page_header();
}

sub make_cgi_footer{
  cluck( 'Deprecated: use EnsEMBL::HTML::Page::ensembl_page_footer' );
  return EnsEMBL::HTML::Page::ensembl_page_footer();
}

sub print_form{
  cluck( 'Deprecated: use EnsEMBL::HTML::Page::ensembl_search_table' );
  return EnsEMBL::HTML::Page::ensembl_search_table();
}

sub helpLink{
  cluck( 'Deprecated: use EnsEMBL::HTML::Page::ensembl_help_link' );
  return EnsEMBL::HTML::Page::ensembl_help_link(); 
}

sub format_date { 
    my ($sec, $min, $hour, $day, $month, $year) = localtime();
    $year  += 1900;
    $month += 1;
	return sprintf( "%04d-%02d-%02d %02d:%02d:%02d", $year, $month, $day, $hour, $min, $sec );
}

###############################################################################
# Generate a unique id 
###############################################################################
sub get_unique_id {
    my $hostname=substr(hostname(),0,8);
    my $pid=$$;
    my $systime=substr(time, -7);
    
    # now encode pairs of numbers as letters, where possible
    my $numid=$pid.$systime;
    my %letters;
    @letters{(10..36 , 40..66)} = ('A'..'Z','a'..'z');
    
    my $packednum;
    foreach my $pair (unpack ("A2" x (1+length($numid)/2),$numid)){
	$packednum .= $letters{$pair} || $pair;
    }
    return $hostname.$packednum;
}

###############################################################################
# bp_to_nearest_unit
#   Takes a number in basepairs and returns a formatted string rounding the 
#   number to the nearest useful unit.
###############################################################################
sub bp_to_nearest_unit {
    my ($bp,$dp) = @_;
    $dp = 2 unless defined $dp;
    
    my @units = qw( bp Kb Mb Gb Tb );
    
    my $power_ranger = int( ( length( abs($bp) ) - 1 ) / 3 );
    my $unit = $units[$power_ranger];
    my $unit_str;

    my $value = int( $bp / ( 10 ** ( $power_ranger * 3 ) ) );
      
    if ( $unit ne "bp" ){
	$unit_str = sprintf( "%.${dp}f%s", $bp / ( 10 ** ( $power_ranger * 3 ) ), " $unit" );
    }else{
	$unit_str = "$value $unit";
    }
    return $unit_str;
}

sub update_config {
  my( $Config, $cgi ) = @_;
# Loop through each of the cgi parameters looking for those starting "x_..."
# These are the hidden variables indicating which checkboxes have been displayed.
# We have a minor "hack" as the imagemap isn't really an "on/off" checkbox...
  foreach ( $cgi->param ) {
    if(/^x_(.*)/) {
      my ($key,$value) = ( $1, $cgi->param($1) );
      if($key eq 'imagemap') {
        $Config->set( '_settings', 'imagemap', defined $value ? 1 : 0);
      } else {
        $Config->set( $key, 'on', $value || 'off' );
      }
    }
  }
  $Config->save();
}

###############################################################################
# translate
#   Takes a number - possibly including an M or a K and converts it into a
#   number of pages...
###############################################################################
sub translate {
	my $location = shift;
    return $location unless ($location > 0) || ($location < 0);
	$location*=1e6 if $location =~/M/i;
	$location*=1e3 if $location =~/K/i;
	$location*=1;
	return $location;
}

###############################################################################
# is_real_chr
#   Takes a chromosome name and returns 1 if that chr is found in the defined
#   list of chromosomes for that species, and 0 if not
###############################################################################
sub is_real_chr {
    my $chr = shift;
    $chr = uc($chr);
    
    my %chromo;
    @chromo{@{EnsWeb::species_defs->ENSEMBL_CHROMOSOMES}}=();

    return exists $chromo{$chr} ? 1 : 0 ;
}


###############################################################################
# is_installed_species
#   Takes a species name and returns 1 if that species is installed on this
#   site, and 0 if not
###############################################################################
sub is_installed_species {
    my $species = shift;
    
    my %spp;
    @spp{@{EnsWeb::species_defs->ENSEMBL_SPECIES}}=();

    return exists $spp{$species} ? 1 : 0 ;
}
1;

