package EnsEMBL::Web::UserConfig::contigviewtop;
use strict;
use EnsEMBL::Web::UserConfig;
use vars qw(@ISA);
@ISA = qw(EnsEMBL::Web::UserConfig);

sub init {
  my ($self) = @_;
  $self->{'_userdatatype_ID'} = 2;
  $self->{'general'}->{'contigviewtop'} = {
    '_artefacts'   => [],
    '_settings'    => {
      'width'             => 900,
      'label_width'       => 130,
      'draw_red_box'      => 'yes',
      'default_vc_size'   => 1000000,
      'show_contigview'   => 'yes',
      'imagemap'          => 1,
      'bgcolor'           => 'background1',
      'bgcolour1'         => 'background1',
      'bgcolour2'         => 'background1',
    }
  };

  $self->ADD_GENE_TRACKS();
  $self->ADD_SYNTENY_TRACKS();
  my $POS = 0;
  
  $self->add_track( 'contig',   'on'=>'on', 'pos' => $POS++ );
  $self->add_track( 'scalebar', 'on'=>'on', 'pos' => $POS++, 'str' => 'f', 'abbrev' => 'on' );
  $self->add_track( 'marker',   'on'=>'on', 'pos' => $POS++,
                    'col' => 'magenta', 'colours' => {$self->{'_colourmap'}->colourSet( 'marker' )},
                    'labels'    => 'on',
                    'available' => 'features markers',
                    'track_label'=> 'Rice_Markers',
                  );
  
  my $ID = sub{(split('-',$_[0]))[0]};
  my %EXTRA;
  $EXTRA{labels} = 'on';
  $EXTRA{NO_ALIGNMENT} = 1;
  $self->add_new_track_genericmatch( 
	  'Rice_QTL', 'Rice_QTL', 'green', 10000, 
	  'str'=>'r', 'dep'=>9999,
          'on'=>'on',
          #'SUBTYPE' => $type,
          'ZMENU'   => [ "QTL: ###ID###",
			 '01:QTL_DB'=>'###QTL###',
			 '10:View all hits' =>'###FEATUREVIEW_DNA###'],
          #'URL_KEY' => 'QTL',
          $ID ? ('ID'=>$ID ) : (),
          %EXTRA, 
	  #%extra,
    );

  $self->add_track( 'chr_band', 'on'=>'on', 'pos' => $POS++ );

  $POS = 100000;
  $self->add_track( 'gene_legend', 'str' => 'r', 'on'=>'on', 'pos' => $POS++ );
}

1;
