package EnsEMBL::Gramene::Document::HTML::Title;
use strict;
use EnsEMBL::Web::Document::HTML::Title;

@EnsEMBL::Gramene::Document::HTML::Title::ISA = 
    qw(EnsEMBL::Web::Document::HTML::Title);

sub set    { 
  # GRAMENE - The E::W::D::Common->set_title method prefixes the title
  # with the ensembl version. We want to use the gramene version
  # instead.
  my $self = shift;
  my $title = shift;

  if( my $grm_vers = $SiteDefs::PerlSetVar{gramene_version} ){
    my $ens_vers = $SiteDefs::ENSEMBL_VERSION;
    $title =~ s/$ens_vers/$grm_vers/;
  }
  $self->{'title'}  = $title; 
}

1;

