package EnsEMBL::Gramene::Document::HTML::SearchBox;
use strict;
use CGI qw(escapeHTML);
use EnsEMBL::Web::Document::HTML;
use EnsEMBL::Web::SpeciesDefs;
use EnsEMBL::Web::Document::HTML::SearchBox;

our @ISA = qw(EnsEMBL::Web::Document::HTML::SearchBox);

our $SD = EnsEMBL::Web::SpeciesDefs->new();

sub render {
  my $self = shift;

  my $outer_tmpl = qq(
<div id="grm_genome_search">
<form action="/%s/%s" method="GET" name="feederform">
<input type="hidden" name="species" value="%s">
<dl>
 <dd>
  <input type="submit" value="Search" >
 </dd>
 <dd>
  <input name="q" size="15" value="">  
 </dd>
 <dd>
  <select name="type">%s
  </select>
 </dd>
</dl>
</form>
</div> );
 
  my $option_tmpl = qq(
   <option value="%s"> %s </option> );

  my $option_str = join( '', 
                         map{sprintf( $option_tmpl, $_, $_ )}
                         ( 'All', @{$self->{'indexes'}} ) );

  my $species = $ENV{'ENSEMBL_SPECIES'};
  if( $species eq 'Multi' ) { $species = ''; }
  
  $self->print( sprintf( $outer_tmpl,
                         $species || 'perl',
                         $SD->ENSEMBL_SEARCH,
                         $species || 'all',
                         $option_str,
                         ) );
}

1;

