package EnsEMBL::Gramene::Document::Configure;
use Gramene::Page;
our $SD = EnsEMBL::Web::SpeciesDefs->new();

sub common_page_elements {
  my($self,$doc) = @_;

  # We have to atach some variables to the apache request as these are
  # required by Gramene::Page. The variables themselves are set in the
  # SiteDefs.pm plugin.
  # These should remain available on the Apache Request within other modules
  my $r = Apache->request;
  foreach my $key( keys %SiteDefs::PerlSetVar ){
    $r->dir_config->add($key,$SiteDefs::PerlSetVar{$key});
  }

  # Gramene header/title
  $doc->replace_head_element
      ('title'     => 'EnsEMBL::Gramene::Document::HTML::Title');
 $doc->replace_body_element
      ('masthead'  => 'EnsEMBL::Gramene::Document::HTML::MastHead');
  # Gramene footer
  $doc->replace_body_element 
      ('copyright' => 'EnsEMBL::Gramene::Document::HTML::Copyright');
  # Unwanted stuff
  $doc->replace_body_element
      ('searchbox' => 'EnsEMBL::Gramene::Document::HTML::SearchBox');
  $doc->replace_body_element 
      ('release'   => 'EnsEMBL::Web::Document::HTML::Null');
  $doc->replace_body_element
      ('helplink'  => 'EnsEMBL::Web::Document::HTML::Null');
  return 1;
}

sub dynamic_page_elements{
  my($self,$doc) = @_;
#  warn ("FOOBAR!");
#  $doc->set_title('FOOBAR!');
#  warn( "==> $self $doc" );
}

sub extra_configuration{
  my($self,$doc) = @_;
  # GRAMENE SPECIFIC stylesheets and javascript files
  my $gpage = Gramene::Page->new( Apache->request ) 
      || die( "Cannot create a Gramene::Page" );
  foreach my $css( $gpage->stylesheets ){
    $doc->stylesheet->add_sheet( 'screen', $css );
  }
  foreach my $file( $gpage->javascripts ){
    $doc->javascript->add_source( $file );
  }
}

sub common_menu_items {
  my($self,$doc) = @_;
  my $menu = $doc->menu;

  # Wipe all existing blocks
  map{ $menu->delete_block($_) } $menu->blocks;

  # Add search block
  my $common_name = $ENV{'ENSEMBL_SPECIES'} ? 
                    $SD->SPECIES_COMMON_NAME : 'Genomes';
  $common_name = 'Genomes' if $common_name =~ /multi/i;
  $menu->add_block('search','attribute', "Find in $common_name" );

  # Add new block
  $menu->add_block('browser_links','attribute','Browser Links');
  $menu->add_entry( 'browser_links',
                    'code'  => 'genomes_home',
                    'href'  => "/genome_browser",
                    'text'  => 'Genomes Home',
                    'title' => "Genomes home page" );
  $menu->add_entry( 'browser_links',
                    'code'  => '',
                    'href'  => "/tutorials/genomes.html",
                    'text'  => 'Genomes Help',
                    'title' => "Genomes help/FAQ/tutorial pages" );

  my @sp_options;
  foreach my $sp( sort keys %SiteDefs::__species_aliases ){
    my $sp_label = $sp;
    next if $sp_label =~ /Zea_mays2/i; #hide the Zea mays2 
    $sp_label =~ s/_/ /g;
    push @sp_options, {text=>$sp_label, href=>"/$sp"};
  }  
  push @sp_options, {text=>'Organelles',href=>"/organelles"};
  $menu->add_entry('browser_links',
                   'code'=>'switch_species',
                   'text'=>'Switch Species',
                   href=>'/genome_browser',
                   options=>[@sp_options]);

}

sub static_menu_items {
  my($self,$doc) = @_;
}

sub dynamic_menu_items {

}

1;
