package EnsEMBL::Gramene::Configuration::Location;
use strict;
use EnsEMBL::Web::Configuration::Location;
our @ISA = qw( EnsEMBL::Web::Configuration);

#----------------------------------------------------------------------
# Gramene-specific ContigView
sub contigview {
  my $self   = shift;
  my $document = $self->{page};
  my $content  = $document->content; 

  my $panel;
  foreach my $code( $content->panels ){
    if( $code =~ m/bottom/ ){
      $panel = $content->panel($code);
      last;
    }
  }

  if( $panel ){
    # Replace menu with Gramene's (EST and GSS options)
#    $panel->remove_component('menu');
    $panel->replace_component
        ( 'menu'=>
          'EnsEMBL::Gramene::Component::Location::contigviewbottom_menu' );
  }

  return 1;

}

# We only want a 'Graphical view' if CONTIGVIEW_ENABLED
sub context_menu{
  my $self = shift;
  my $obj  = $self->{object};
  return unless $self->{page}->can('menu');
  my $menu = $self->{page}->menu || return;
  
  my $cytoview = $obj->species_defs->CONTIGVIEW_ENABLED;
  if( defined( $cytoview ) and ! $cytoview ){
    # Remove 'Graphical View' from menu
    # The 'code' for the entry is 'cv_link'
    my $flag = "contig$self->{'flag'}";
    $menu->delete_entry( $flag, 'cv_link' );
  }

  my $species =  $obj->species();
  my $script  = $ENV{'ENSEMBL_SCRIPT'};

  #  if( $obj->species_defs->get_table_size( {-db=>'core',-table=>'dna'} ) ){
  # it looks like the get_table_size is not workin properly
  # Remove 'Export sequence as FASTA' from menu if dna table empty
  # There is no 'code' for this entry. Darn! Have to hack the object
  
  if( $species =~ /Zea_mays/i && $script =~ /cytoview|exportview/i ){

    my $flag = "contig$self->{'flag'}";
    my @texts = ( 'Export sequence as FASTA',
		  'Export EMBL file'
		);
    if( $menu->{'blocks'}{$flag} and $menu->{'blocks'}{$flag}{'entries'}){
      $menu->{'blocks'}{$flag}{'entries'} 
        = [ grep { $_->{text} ne $texts[0] && $_->{text} ne $texts[1]} 
            @{$menu->{'blocks'}{$flag}{'entries'}} ];
    }
  }
}

# 
sub exportview {
  my $self = shift;
  my $doc  = $self->{page};
  my $obj  = $self->{object};
  my $data = $self->{object}->__data;
  # Remove the FASTA option if the dna table is not populated
#  unless( $obj->species_defs->get_table_size( {-db=>'core',-table=>'dna'} ) ){
#  foreach my $format( 'fasta','pipmaker' ){
#    delete( $data->{'formats'}{$format} );
#  }
#  warn "==>".join(", ", keys %{$data->{'formats'}} );
  my $content = $doc->content;
  my $panel   = $content->panel('stage1_form') || return;
  my $form     = $panel->form('stage1_form')   || return;

  # Need to find the 'format' element, and remove the unwanted options
  my($element) = grep{ $_->{name} eq 'format' } @{$form->{'_elements'}};
  UNIVERSAL::isa($element, 'EnsEMBL::Web::Form::Element') || return;
  #$element->{values} = [];

}


# fix the cytoview duplication problem
sub cytoview {
    my $self = shift;

    # warn("Who wants to know???");
}


1;
