package EnsEMBL::Gramene::Configuration::Gene;
use strict;
use EnsEMBL::Web::Configuration;
our @ISA = qw( EnsEMBL::Web::Configuration );

# Gramene-specific GeneView configuration.
sub geneview{
  my $self   = shift;
  my $document = $self->{page};
  my $content  = $document->content;

  # Top (Gene) Panel
  my $panel = $content->panel('info0');
  $panel->replace_component
      qw( name EnsEMBL::Gramene::Component::Gene::name );
  #$panel->remove_component
  #    qw( stable_id );
  $panel->remove_component
      qw( diseases );

  #$panel->replace_component
  #    qw( orthologues, EnsEMBL::Gramene::Component::Gene::orthologues );

  # Bottom (Transcript) Panels
  PANEL: 
  foreach my $panel_name( $content->panels ){
    unless( $panel_name =~ /^trans/ ){ next PANEL }
    my $tpanel = $content->panel($panel_name);
    $tpanel->replace_component
        qw( go 
            EnsEMBL::Gramene::Component::Transcript::go );
    $tpanel->replace_component
        qw( similarity
            EnsEMBL::Gramene::Component::Transcript::similarity_matches );
  }

  return 1;
}

# Swaps the name and stable_id components for Gramene versions
sub _change_gene_name{
  return; # Disable for v39
  my $self   = shift;
  my $document = $self->{page};
  my $content  = $document->content;
  # Top (Gene) Panel
  my $panel = $content->panel('info0');
  $panel->replace_component
      qw( name EnsEMBL::Gramene::Component::Gene::name );
  $panel->remove_component
      qw( stable_id );

}

sub genespliceview{
  my $self   = shift;
  return $self->_change_gene_name(@_);
}

sub geneseqview{
  my $self   = shift;
  return $self->_change_gene_name(@_);
}

sub genesnpview{
  my $self   = shift;
  return $self->_change_gene_name(@_);
}

sub context_menu{
  # Needed to prevent duplicated menu
}
