package EnsEMBL::Gramene::Configuration::Chromosome;
use strict;
use EnsEMBL::Web::Configuration;
our @ISA = qw( EnsEMBL::Web::Configuration );

## Function to configure map view
## MapView uses a single panel to display a chromosome image plus 
## table rows containing basic information and 'navigation' forms

sub mapview {
  my $self   = shift;

  my $document = $self->{page};
  my $content  = $document->content; 
  my $panel    = $content->panel('info');

  $panel->remove_component('change_chr'); # Move to sidebar

  $panel->add_component_first
      ( 'disclaimer'=>'EnsEMBL::Gramene::Component::Chromosome::disclaimer');

  $panel->replace_component
      ( 'image'=>'EnsEMBL::Gramene::Component::Chromosome::chr_map');

  $panel->replace_component
      ( 'stats'=>'EnsEMBL::Gramene::Component::Chromosome::stats');

  my $chromosome = $self->{object};
  my $species    = $chromosome->species;
  my $chr_name   = $chromosome->chr_name;
  my @chr_options;

  foreach my $chr( @{$chromosome->species_defs->ENSEMBL_CHROMOSOMES || []} ){
    push( @chr_options, {text => "Chromosome $chr",
                        href => "/$species/mapview?chr=$chr",
                        raw  => 1} );
  }

  my $menu     = $document->menu;

  $menu->add_entry_after( 'chromosome','syntview',
                    code => 'switch',
                    text => 'Switch Chromosome',
                    href => "/$species/mapview?chr=$chr_name",
                    options => [ @chr_options ]);

=stub

  my $otherspecies = $species eq 'Oryza_sativa' ? 'Zea_mays' : 'Oryza_sativa';#$chromosome->param("otherspecies");
  my @otherspecies_options = ();
  foreach my $other_sp( $otherspecies ){
    push( @otherspecies_options, {text => "$species v.s. $other_sp",
                         href => ( "/$species/syntenyview".
                                   "?chr=$chr_name&otherspecies=$other_sp" ),
                         raw  => 1} );
  }

  $menu->add_entry_after( 'chromosome','syntview',
                    code => 'switch',
                    text => 'Synteny',
                    href => ( "/$species/syntenyview".
                              "?chr=$chr_name&otherspecies=$otherspecies" ),
                    options => [ @otherspecies_options ]);

=cut

}


#----------------------------------------------------------------------
# Gramene-specific syntenyview config. No need for homology yet.
# Also - move chr selection to sidebar
sub syntenyview {
  my $self   = shift;

  my $document = $self->{page};
  my $content  = $document->content; 
  my $panel    = $content->panel('info');

  # Remove unwanted components
  $panel->remove_component('syn_matches');  # No homology yet
  $panel->remove_component('nav_homology'); # No homology yet
  $panel->remove_component('change_chr');   # Move to sidebar

  # Chromosome-picker as part of sidebar
  my $chromosome   = $self->{object};
  my $otherspecies = $chromosome->param("otherspecies");
  my $species      = $chromosome->species;
  my $chr_name     = $chromosome->chr_name;
  my @chr_options;

  foreach my $chr( @{$chromosome->species_defs->ENSEMBL_CHROMOSOMES || []} ){
    push( @chr_options, {text => "Chromosome $chr",
                         href => ( "/$species/syntenyview".
                                   "?chr=$chr&otherspecies=$otherspecies" ),
                         raw  => 1} );
  }

  my $menu     = $document->menu;
  my $block    = $menu->block('chromosome');
  $menu->add_entry_after( 'chromosome','syntview',
                    code => 'switch',
                    text => 'Switch Chromosome',
                    href => ( "/$species/syntenyview".
                              "?chr=$chr_name&otherspecies=$otherspecies" ),
                    options => [ @chr_options ]);

}
