package EnsEMBL::Gramene::Component::Transcript;
use strict;
use EnsEMBL::Web::Component::Transcript;
our @ISA = qw( EnsEMBL::Web::Component::Transcript);

# GRAMENE - We change the description of how the terms were mapped,
# and link to Gramene ontology rather than Ensembl GoView
sub go{
  my( $panel, $object ) = @_;
  my $label = 'GO';

  # TODO: If object is a Translation, get the Transcript object
  if( $object->__objecttype eq 'Translation'){
    $object = $object->get_transcript_object;
  }

  unless ($object->__data->{'go_links'}){
    # Nothing cached. Generate similarity links.
    my @similarity_links = @{$object->get_similarity_hash($object->Obj)};
    return unless (@similarity_links);
    EnsEMBL::Web::Component::Transcript::_sort_similarity_links
        ($object, @similarity_links);
  }
  my $go_hash = $object->get_go_list() || return;

  my $html = ('<dl><dt><strong>The following GO terms have been mapped to '. 
              'this entry via '.
              '<a href="http://www.ebi.ac.uk/interpro/README1.html">'.
              '<strong>InterProScan</strong></a>:</strong></dt>' );

  foreach my $go (sort keys %{$go_hash}){
    my @go_data = @{$go_hash->{$go}||[]};
    my( $evidence, $desc ) = @go_data;
    my $link = $desc;
    #$link =~ s/ /+/g;
    my $goidurl  = $object->get_ExtURL_link($go,'GO',$go);
    my $queryurl = $object->get_ExtURL_link($desc,'GOTERMNAME',$link);
    my $evidurl  = $object->get_ExtURL_link
        ($evidence,'GOEVIDENCECODE',$evidence);
    my $tmpl = '<dd>%s [%s] <code>%s</code></dd>'."\n";
    $html .= sprintf
        ( $tmpl, $goidurl, $queryurl, $evidurl );
  }
  $html .= qq(</dl>);
  $panel->add_row( $label, $html );
}

# GRAMENE Get rid of he [align] link from similarity xrefs
# TODD: Implement ExtIndex modules that search proteins and markers DBs
sub similarity_matches {
  my( $panel, $transcript ) = @_;
  my $label = $transcript->species_defs->translate( 'Similarity Matches' );# shift || 'Similarity Matches';
  my $trans = $transcript->transcript;
  # Check cache
  unless ($transcript->__data->{'similarity_links'}){
    my @similarity_links = @{$transcript->get_similarity_hash($trans)};
    return unless (@similarity_links);
    EnsEMBL::Web::Component::Transcript::_sort_similarity_links
        ($transcript, @similarity_links);
  }

  my @links = @{$transcript->__data->{'similarity_links'}};
  return unless @links;

  my $db = $transcript->get_db();
  my $entry = $transcript->gene_type || 'Ensembl';

    # add table call here
  my $html;
  unless ($transcript->species_defs->ENSEMBL_SITETYPE eq 'Vega') {
    $html = qq(<p><strong>This $entry entry corresponds to the following database identifiers:</strong></p>);
  }
  $html .= qq(<table cellpadding="4">);
  my $old_key = '';
  foreach my $link (@links) {
    my ( $key, $text ) = @$link;

    # GRAMENE - this is the line that removes the link...
    $text =~ s/\[\<a\s+href\=.+?align.+?\]//g;

    if( $key ne $old_key ) {
      if($old_key eq "GO") {
        $html .= qq(<div class="small">GO mapping is inherited from swissprot/sptrembl</div>);
      }
      if( $old_key ne '' ) {
        $html .= qq(</td></tr>);
      }
      $html .= qq(<tr><th style="white-space: nowrap; padding-right: 1em">$key:</th><td>);
      $old_key = $key;
    }    
    $html .= $text;
  }
  $html .= qq(</td></tr></table>);
  $panel->add_row( $label, $html );
}

