package EnsEMBL::Gramene::Component::Gene;
use strict;
use EnsEMBL::Web::Component::Gene;
our @ISA = qw( EnsEMBL::Web::Component::Gene);

sub name{
  my( $panel, $object ) = @_;
  my( $display_name, $dbname, $ext_id, $dbname_disp ) 
      = $object->display_xref();
  $display_name ||= $object->stable_id; # Revert to stable ID
  if( $ext_id ){
    $display_name 
        = $object->get_ExtURL_link( $display_name, $dbname, $ext_id );
  }
  my $display_html = sprintf('<p><strong>%s</strong>', $display_name );
  if( $dbname ){ $display_html .= sprintf( ' (%s)', $dbname ) }
  $panel->add_row( $object->type_name(), $display_html );
  return 1;
}


# Copy the orthologues method from ensembl v38, E::W::Component::Gene
# Add a link to gene trees
sub orthologues {
#  EnsEMBL::Web::Component::Gene->orthologues(@_);
#  my( $panel, $object ) = @_;
#  $panel->add_row("FOO", "BAR");
}

# Copy the get_homology_matches method from ensembl v38
# E::W::Object::Gene, as we do not yet have gene trees
sub get_homology_matches_foo{
  my $web_gene = shift;
  my $homology_source = shift;
  $homology_source = "ENSEMBL_ORTHOLOGUES" unless (defined $homology_source);
  my %homologues = %{&fetch_homology_species_hash($web_gene,$homology_source)};
  return unless keys %homologues;
  my $gene = $web_gene->Obj;
  my $geneid = $gene->stable_id;
  my %homology_list;
  my $adaptor_call = $web_gene->param('gene_adaptor') || 'get_GeneAdaptor';

  foreach my $displayspp (keys (%homologues)){
    ( my $spp = $displayspp ) =~ tr/ /_/;
    foreach my $homology (@{$homologues{$displayspp}}){
      my ($homologue, $homology_desc, $homology_dnds_ratio) = @{$homology};
      my $homologue_id = $homologue->stable_id;
      $homology_list{$displayspp}{$homologue_id}{'homology_desc'} = $homology_desc ;
      $homology_list{$displayspp}{$homologue_id}{'homology_dnds_ratio'} = $homology_dnds_ratio ;
      $homology_list{$displayspp}{$homologue_id}{'spp'} = $displayspp ;
      $homology_list{$displayspp}{$homologue_id}{'description'} = $homologue->description ;
      if ($web_gene->species_defs->valid_species($spp)){
        my $database_spp = $web_gene->DBConnection->get_databases_species( $spp, 'core') ;
        unless( $database_spp->{'core'} ) {
          warn "NO CORE DB CONNECTION ($spp)";
          next;
        }
        my $geneadaptor_spp = $database_spp->{'core'}->$adaptor_call;
                my $gene_spp = $geneadaptor_spp->fetch_by_stable_id( $homologue->stable_id, 1 );
        unless ( $gene_spp ) {
          warn "Gene @{[$homologue->stable_id]} not in core database for $spp";
          next;
        }
        my $display_xref = $gene_spp->display_xref;
        my $display_id = $display_xref ?  $display_xref->display_id() : 'Novel Ensembl prediction';
        $homology_list{$displayspp}{$homologue_id}{'display_id'} = $display_id;
        $homology_list{$displayspp}{$homologue_id}{'description'} = $gene_spp->description || 'No description';
        $homology_list{$displayspp}{$homologue_id}{'location'}= $gene_spp->feature_Slice->name;
        $database_spp->{'core'}->dbc->disconnect_if_idle();
      }
    }
  }
  return \%homology_list;
}


# Copy the fetch_homology_species_hash method from ensembl v38
# E::W::Object::Gene, as we do not yet have gene trees
sub fetch_homology_species_hash_foo {
  my $web_gene = shift;
  my $homology_source = shift;
  $homology_source = "ENSEMBL_ORTHOLOGUES" unless (defined $homology_source);
  my $geneid = $web_gene->stable_id;
  my $databases = $web_gene->database('compara') ;
  my %homologues;

  return {} unless $databases;

  my $member_adaptor = $databases->get_MemberAdaptor;
  my $query_member = $member_adaptor->fetch_by_source_stable_id("ENSEMBLGENE",$geneid);

  return {} unless defined $query_member ;
  my $homology_adaptor = $databases->get_HomologyAdaptor;
  my $homologies_array = $homology_adaptor->fetch_all_by_Member_method_link_type($query_member,$homology_source);
  foreach my $homology (@{$homologies_array}){
    foreach my $member_attribute (@{$homology->get_all_Member_Attribute}) {
      my ($member, $attribute) = @{$member_attribute};
      next if ($member->stable_id eq $query_member->stable_id);
      push (@{$homologues{$member->genome_db->name}}, [ $member, $homology->description, $homology->dnds_ratio ]);
    }
  }
  return \%homologues;
}
