package DiseaseKwIndex;

=head1 NAME

DiseaseKwIndex

=head1 SYNOPSIS

Subclass of DBIx::KwIndex.pm - a generic full text indexer.

=head1 DESCRIPTION

This subclasses the DBIx::KwIndex.pm indexer.  It provides a single subroutine - document_sub - that must take a list of record id's, and return an array index of those records for indexing.

=head1 AUTHOR

James Stalker - jws@sanger.ac.uk

=cut

use base 'DBIx::KwIndex';

use strict;

sub document_sub {

my ($self, $id_array_ref) = @_;
	my $dbh = $self->{dbh};

	my $result = $dbh->selectall_arrayref(
		'SELECT id,disease FROM disease WHERE id IN ('
			. join ( ',', @$id_array_ref ).')' );
	
	# if retrieval fails, should return undef
	defined($result) or return undef;

	# must return fields in order requested
	my %tmp = map {$_ ->[0] =>$_->[1] } @$result;
	return [@tmp{@$id_array_ref}];

}

1;
