package Bio::EnsEMBL::GlyphSet::generic_match;
use strict;
use Bio::EnsEMBL::GlyphSet_feature;
@Bio::EnsEMBL::GlyphSet::generic_match::ISA = qw(Bio::EnsEMBL::GlyphSet_feature);

sub my_label { 
  my $self = shift;
  return $self->my_config('TEXT_LABEL') || 'Missing label';
}

sub colour {
  my( $self, $id, $feature ) = @_;
  my $colours =  $self->{'colours'}->{ $self->object_type($id, $feature) } ||
                 $self->my_config('col') || 'black';
}

sub features {
  my ($self) = @_;

  my $method    = $self->my_config('CALL')||'get_all_DnaAlignFeatures';
  my $database  = $self->my_config('DATABASE') || undef;
  my $threshold = ( defined( $self->my_config('THRESHOLD')) ? 
                    $self->my_config('THRESHOLD') : 80 );

  my @logic_names;
  if( $self->my_config( 'FEATURES' ) eq 'UNDEF' ) {
    @logic_names = ( undef() );
  } else {
    @logic_names = split( /\s+/, 
                          ( $self->my_config( 'FEATURES' ) ||
                            $self->check() ) );
  }   
  my @feats;
  foreach my $nm( @logic_names ){
    push( @feats, @{$self->{'container'}->$method($nm,$threshold,$database)} );
   # warn( @feats );
  }
  return [@feats];
}

sub object_type {
  my($self,$id,$feature)=@_;
  my $F = $self->my_config('SUBTYPE');
  return $self->{'type_cache'}{$id} ||= ref($F) eq 'CODE' 
      ? &$F($id,$feature) : $F;
}

sub SUB_ID {
  my( $self, $id ) = @_;
  my $T = $self->my_config('ID');
  if( ref( $T ) eq 'HASH' ) {
    $T = $T->{ $self->object_type($id) }  || $T->{'default'};
  }
  return ( $T && ref( $T ) eq 'CODE' ) ? &$T( $id ) : $id;
}

sub SUB_LABEL {
  my( $self, $id ) = @_;
  my $T = $self->my_config('LABEL');
  if( ref( $T ) eq 'HASH' ) {
    $T = $T->{ $self->object_type($id) }  || $T->{'default'};
  }
  return ( $T && ref( $T ) eq 'CODE' ) ? &$T( $id ) : $id;

}

sub SUB_HREF { return href( @_ ); }

sub href {
  my ( $self, $id ) = @_;
  my $T = $self->my_config('URL_KEY');
  if( ref( $T ) eq 'HASH' ) {
    $T = $T->{ $self->object_type($id) };
  }
  return $self->ID_URL( $T || 'SRS_PROTEIN' , $self->SUB_ID( $id ) );
}

sub zmenu {
  my ($self, $id, $feature_info, $slice_info ) = @_;

  my $T = $self->my_config('ZMENU');

  if( ref( $T ) eq 'HASH' ) {
    $T = $T->{ $self->object_type($id) } || $T->{'default'};
  }
  $id =~ s/'/\'/g; #'
  my @T = @{$T||[]};
  my @zmenus=('caption');
  foreach my $t(@T){
    if( $t =~ m/###(\w+)###/ ){
        if( $t =~ m/FEATUREVIEW/ ){
          # Nasty hack. FeatureView must use $id! Always!
          $t =~ s/###(\w+)###/$self->ID_URL( $1, $id )/eg;
        }
      elsif( $self->can( "SUB_$1" ) ){ 
        my $m="SUB_$1"; 
        $t =~ s/###(\w+)###/$self->$m($id)/eg }
      else{ $t =~ s/###(\w+)###/$self->ID_URL( $1, $self->SUB_ID( $id ) )/eg }
    }
    push @zmenus, $t;
  }
  my $zmenu={ @zmenus };

#  my $zmenu = {( 'caption', map { s/###(\w+)###/my $M="SUB_$1";$self->$M($id)/eg; $_ } @T )} if $T && @T;
#  my $extra_URL  = "/@{[$self->{container}{_config_file_name_}]}/featureview?type=";
#  $extra_URL .= ( $self->my_config('CALL') eq 'get_all_ProteinAlignFeatures' ?
#                  'ProteinAlignFeature' : 'DnaAlignFeature' );
#  $extra_URL .= "&id=$id";
#  $extra_URL .= "&db=".$self->my_config('DATABASE') if $self->my_config('DATABASE');

#  $zmenu->{ 'View all hits' } = $extra_URL;

  # Gramene extra
  unless ($self->my_config('NO_ALIGNMENT')) {
      my $logic_name =(  $self->my_config('FEATURES') || 
			 $self->my_config('LOGIC_NAME') );
      my $slice_name  = $slice_info->[0];
      my $slice_start = $slice_info->[1] - 1;
      my $chr_start   = $slice_start + ( $feature_info->[0][0]  || 1 );
      my $chr_end     = $slice_start + ( $feature_info->[-1][1] || 1 );


      my $align_link = ("/Multi/show_alignment.pl".
		       "?chr=$slice_name&chr_start=$chr_start&chr_end=$chr_end".
		       "&feature_id=$id".
		       "&blastdb=$logic_name.fa".
		       "&species=$ENV{ENSEMBL_SPECIES}");

      $zmenu->{ 'View alignment' } = $align_link;
  }
  return $zmenu;
}
1;
