package Bio::EnsEMBL::GlyphSet::bac_map;
use strict;
use vars qw(@ISA);
use Bio::EnsEMBL::GlyphSet_simple;
@ISA = qw(Bio::EnsEMBL::GlyphSet_simple);

sub my_label {
  my $self = shift;
  my $label = $self->my_config('track_label') || 'BAC map';
  my $numchars = 16;
  my $print_label = $label; #( length($label) > $numchars ?
		      #substr($label, 0, ($numchars-2)).'..' :
		      #$label );
  return $print_label;
}

## Retrieve all BAC map clones - these are the clones in the
## subset "bac_map" - if we are looking at a long segment then we only
## retrieve accessioned clones ("acc_bac_map")

sub features {
    my ($self) = @_;
    my $container_length = $self->{'container'}->length();
    my $code = $self->my_config('misc_set_code') || "bac_map";
    my $max_full_length  = $self->my_config('full_threshold' ) || 2e4;

    # Context-sensitive display.
    if( $container_length > $max_full_length*1001 ){
      # Long segment
      $code = $self->my_config('misc_set_code_long') || "acc_bac_map";
    }

    my %sort = ('synteny_group'=>3,'synteny_singleton'=>2,'no_synteny'=>1);
    my @sorted = 
        ( 
          map { $_->[1] }
          sort { $a->[0] <=> $b->[0] }
          map { [$_->seq_region_start - 
                 1e9 * (
                        ($sort{$_->get_scalar_attribute('state')} || 0)
                        + $_->get_scalar_attribute('BACend_flag')/4
                        ), $_] } 
          @{$self->{'container'}->get_all_MiscFeatures( $code )} 
         );

    # Sort out the legend
    my %legend=( 'col_synteny_group' => 'Synteny component to O.sativa',
                 'col_synteny_singleton' => 'Singleton mapping to O.sativa',
                 'col_no_synteny'        => 'Unmapped to O.sativa');
    $self->{'config'}->{'bac_map_legend_features'} 
    = { map{ $_=>{'legend'=>[$legend{$_}||$_,$self->{'colours'}->{$_}] } } 
        grep{ /col.+synteny/ } 
        keys %{$self->{'colours'}} };

    warn Data::Dumper::Dumper( $self->{'config'}->{'bac_map_legend_features'} );
#      = { 'red'  => { 'legend' => ['red' =>'red' ] },
#          'blue' => { 'legend' => ['blue'=>'blue'] } };

    return \@sorted;
  }

## If bac map clones are very long then we draw them as "outlines" as
## we aren't convinced on their quality...


sub colour {
    my ($self, $f) = @_;
    (my $state = $f->get_scalar_attribute('state')) =~ s/^\d\d://;
    my $name = $f->get_scalar_attribute('name');
    return ( 
             $self->{'colours'}{"col_$state"},
             $self->{'colours'}{"lab_$state"},
             'border', 
             );
}

## Return the image label and the position of the label
## (overlaid means that it is placed in the centre of the
## feature.

sub image_label {
  my ($self, $f ) = @_;
  return ("@{[$f->get_scalar_attribute('name')]}",'overlaid');
}

## Link back to this page centred on the map fragment

sub href {
    my ($self, $f ) = @_;
    return "/@{[$self->{container}{_config_file_name_}]}/$ENV{'ENSEMBL_SCRIPT'}?mapfrag=@{[$f->get_scalar_attribute('name')]}";
}

sub tag {
    my ($self, $f) = @_; 
    my @result = (); 
    my $bef = $f->get_scalar_attribute('BACend_flag');

    # GRAMENE
    # 
    my @bacends = @{$f->get_all_attribute_values('bacend')};
    my @ssrs    = @{$f->get_all_attribute_values('bacend_ssr')};
    if( @bacends == 2 ){ $bef = 3 }
    elsif( @bacends == 1 ){ $bef = 1 }

    (my $state = $f->get_scalar_attribute('state')) =~ s/^\d\d://;
    my ($s,$e) = $self->sr2slice( $f->get_scalar_attribute('inner_start'), $f->get_scalar_attribute('inner_end') );
    if( $s && $e ){
      push @result, {
        'style'  => 'rect',
        'colour' => $f->{'_colour_flag'} || $self->{'colours'}{"col_$state"},
        'start'  => $s,
        'end'    => $e
      };
    }

    push @result, {
        'style'  => 'right-end',
        'colour' => (scalar(@ssrs) ? 'red' : $self->{'colours'}{"bacend"}),
    } if ( $bef == 2 || $bef == 3 );
    push @result, { 
        'style'=>'left-end',  
        'colour' => (scalar(@ssrs) ? 'red' : $self->{'colours'}{"bacend"} ),
    } if ( $bef == 1 || $bef == 3 );

    my $fp_size = $f->get_scalar_attribute('fp_size');
    if( $fp_size && $fp_size > 0 ) {
        my $start = int( ($f->start + $f->end - $fp_size)/2 );
        my $end   = $start + $fp_size - 1 ;
        #warn ">> @{[$f->start, $f->end, $fp_size]} $start, $end";
        
        #push @result, {
        #    'style' => 'underline',
        #    'colour' => $self->{'colours'}{"seq_len"},
        #    'start'  => $start,
        #    'end'    => $end
        #}
   }
    return @result;
}
## Create the zmenu...
## Include each accession id separately

sub zmenu {
  my ($self, $f ) = @_;
  return if $self->{'container'}->length() > ( $self->{'config'}->get( $self->check(), 'threshold_navigation' ) || 2e7) * 1000;

  my $name = $f->get_scalar_attribute('name');
  my $zmenu = { "caption" => "Clone: $name" };

  my $i = 0;

  $zmenu->{sprintf("%2.2d:Centre on clone",++$i)} = $self->href($f);

  # Extra zmenu from EXTURL hack
  if( my $exturls = $self->species_defs->ENSEMBL_EXTERNAL_URLS ){
    if( my $label = $exturls->{EXT_CLONE_URL_LABEL} ){
      $zmenu->{sprintf("%2.2d:$label: $name",++$i,$name)} 
      = "r?d=EXT_CLONE_URL&ID=$name";
    }
  }

  # Links for accessions
  my @accessions = @{$f->get_all_attribute_values('embl_acc')};
  foreach(@accessions) {
    $zmenu->{sprintf("%2.2d:Jump to BAC Browser",++$i)} =
        "/Zea_mays2/contigview?contig=$_"; #GRAMENE
  }

  $zmenu->{sprintf("%2.2d:Jump to Gramene: $name",++$i)} = 
      "r?d=MARKER&ID=$name"; # GRAMENE

  if( my $ctg = $f->get_scalar_attribute('superctg') ){
    $zmenu->{sprintf("%2.2d:Jump to CMap: $name",++$i)} = 
        "r?d=CMAP_FPC_VIEWER&ID=$ctg&ID2=$name";
  }

  foreach(@accessions) {
    $zmenu->{sprintf("%2.2d:Accession: %s",++$i,$_)} = 
        "r?d=ENTREZ_NUCLEOTIDE&ID=$_";
  }
  foreach(@{$f->get_all_attribute_values('bacend')}) { # GRAMENE
    #$zmenu->{sprintf("%2.2d:BACend: $_",++$i)} = 
    #    "r?d=ENTREZ_NUCLEOTIDE&ID=$_"; 
    $zmenu->{sprintf("%2.2d:BACend: $_",++$i)} = 
        "r?d=GRAMENE_MARKER&ID=$_"; 
  }
  foreach(@{$f->get_all_attribute_values('bacend_ssr')}) { # GRAMENE
    $zmenu->{sprintf("%2.2d:BACend SSR: $_",++$i) } = '';
  }
  foreach(@{$f->get_all_attribute_values('hybridiasation')}) { # GRAMENE
    $zmenu->{sprintf("%2.2d:Hybridised by: $_",++$i) } = 
        "r?d=GRAMENE_MARKER&ID=$_";
  }
  foreach my $val(@{$f->get_all_attribute_values('mapping')}) { # GRAMENE
    $val =~ s/ /\&nbsp\;/g;
    $zmenu->{sprintf("%2.2d:Mapping:&nbsp;$val",++$i) } = "";
  }


  # Extra zmenus can be configured 
  my %extz  = ( %{$self->{'config'}->get( "bac_map", 'ZMENU' )||{}},
                %{$self->my_config('ZMENU')||{}} );
  foreach( keys %extz ){ 
    $zmenu->{sprintf("%2.2d: %s",++$i,$_)} = $extz{$_}; 
  }

  my $start  = $f->seq_region_start;
  my $end    = $f->seq_region_end;
  my $length = $f->length;
  $zmenu->{sprintf("%2.2d:bp: %d-%d",++$i,$start,$end )} = '';
  $zmenu->{sprintf("%2.2d:length: %d",++$i,$length)} = '';

  (my $state = $f->get_scalar_attribute('state'))=~s/^\d\d://;
  my $bac_info = ('Interpolated', 
                  'Start located', 
                  'End located', 
                  'Both ends located') [$f->get_scalar_attribute('BACend_flag')];

  if( my $org = $f->get_scalar_attribute('organisation') ){
    $zmenu->{sprintf("%2.2d::Organisation: %s",++$i,$org)}='';
  }
  if( $state ){
    $zmenu->{sprintf("%2.2d:State: %s",++$i,$state)}='';
  }
  if( my $len = $f->get_scalar_attribute('seq_len') ){
    $zmenu->{sprintf("%2.2d:Seq length: %s",++$i,$len)}='';
  }

#    $zmenu->{"19:FP length:  @{[$f->get_scalar_attribute('fp_size')]}"  } = '' if $f->get_scalar_attribute('fp_size');
  if( my $ctg = $f->get_scalar_attribute('superctg') ){
    $zmenu->{sprintf("%2.2d:FPContig: %s",++$i,$ctg)}='';
  }

#  $zmenu->{"21:BAC flags:  $bac_info"                          } = '' if $bac_info;
#  $zmenu->{"22:FISH:  @{[$f->get_scalar_attribute('FISHmap')]}"       } = '' if $f->get_scalar_attribute('FISHmap');
  return $zmenu;
}



1;
