package EnsEMBL::Gramene::SiteDefs;
use strict;

# These are the gramene-specific edits to the main Ensembl SiteDefs.pm file
sub update_conf {
  warn( "===> ", __PACKAGE__, "->update_conf\n" );

  $SiteDefs::ENSEMBL_PORT                   = 8888;
  $SiteDefs::ENSEMBL_PROXY_PORT             = 80; # Port used for self-referential URLs:
  $SiteDefs::ENSEMBL_USER                   = 'nobody'; #getpwuid($>);     
  $SiteDefs::ENSEMBL_GROUP                  = 'nobody';#getgrgid($));

  $SiteDefs::ENSEMBL_SERVERADMIN            = 'ensembl&#064;gramene.org';
  $SiteDefs::ENSEMBL_SERVERNAME             = 'www.gramene.org';
  #$SiteDefs::ENSEMBL_SERVERNAME             = 'ascutney.cshl.edu';
  $SiteDefs::ENSEMBL_MAIL_ERRORS            = 0;
  $SiteDefs::ENSEMBL_ERRORS_TO              = 'ensembl@gramene.org';

#  $SiteDefs::ENSEMBL_DEBUG_FLAGS            = 25;

#  $SiteDefs::ENSEMBL_TMP_DIR_BLAST          = $SiteDefs::ENSEMBL_SERVERROOT."/blastqueue";
#  $SiteDefs::ENSEMBL_BLASTSCRIPT            = $SiteDefs::ENSEMBL_SERVERROOT."/utils/runblast.pl";

  $SiteDefs::ENSEMBL_USERDB_NAME            = 'ensembl_web_user_db';
  $SiteDefs::ENSEMBL_USERDB_USER            = 'gramene_web';
  $SiteDefs::ENSEMBL_USERDB_HOST            = 'flume.cshl.edu';
  $SiteDefs::ENSEMBL_USERDB_PORT            =  3306;
  $SiteDefs::ENSEMBL_USERDB_PASS            = 'gram3n3';
  $SiteDefs::ENSEMBL_LONGPROCESS_MINTIME    = 10;

#  unshift( @SiteDefs::ENSEMBL_LIB_DIRS, 
#           $SiteDefs::ENSEMBL_SERVERROOT."/public-plugins/gramene/modules");
  unshift( @SiteDefs::ENSEMBL_LIB_DIRS, 
           $SiteDefs::ENSEMBL_SERVERROOT."/gramene-live/lib/perl");
  unshift( @SiteDefs::ENSEMBL_HTDOCS_DIRS,
           $SiteDefs::ENSEMBL_SERVERROOT."/gramene-live/html" );

  #----------
  # Logging
  my $LOG_ROOT = $SiteDefs::ENSEMBL_SERVERROOT."/logs";
  $SiteDefs::ENSEMBL_PIDFILE   = "$LOG_ROOT/httpd.pid";
  $SiteDefs::ENSEMBL_ERRORLOG  = "$LOG_ROOT/error.log";
  $SiteDefs::ENSEMBL_CUSTOMLOG = "$LOG_ROOT/access.log combined";


  #----------
  # Species stuff
  $SiteDefs::ENSEMBL_PERL_SPECIES = 'Oryza_sativa_japonica'; # Default
  $SiteDefs::ENSEMBL_PRIMARY_SPECIES = 'Oryza_sativa_japonica'; # Default
  %SiteDefs::__species_aliases =
    (
     # one of the values has to be the SPECIES_CODE 
     # defined in the species.ini file
     # those are 'os', 'zm' 'zm2' 'at'
     'Oryza_sativa_japonica' => [('rice',
                                  'japonica',
                                  'Homo_sapiens',
                                  'oryza_sativa',
                                  'osativa', 
                                  'os')],
#     'Oryza_sativa_indica'  => [('indica',
#                                 'oi' )],
#     'Oryza_punctata'       => [('punctata',
#                                 'opunctata', 
#                                 'op')],
     'Oryza_rufipogon'       => [('rufipogon',
                                 'orufipogon', 
                                 'or')],

     'Zea_mays'             => [('maize', 
                                 'zm')],

     'Zea_mays2'            => [('Zea_mays_clone',
                                 'zmays', 
                                 'zm2')],
#
     'Arabidopsis_thaliana' => [('arabidopsis',
                                 'athaliana', 
                                 'at')],

#     'Populus_trichocarpa'  => [('poplar',
#                                 'ptrichocarpa', 
#                                'pt')],

#    'Sorghum_bicolor'     => [('sorghum',
#                               'sbicolor',
#                               'sb')]
     );

#  $SiteDefs::ENSEMBL_NOMART ; #Turn on mart, it was $SiteDefs::ENSEMBL_NOMART ++ 

  #--------------------------------------------------
  # Gramene-specific stuff
  # Get the PerlSetVar configuration from main gramene httpd.conf
  # TODO: split this out into a shared text file, or even something that 
  # can be "eval'ed" straight into perl
  my $gramene_confdir = "$SiteDefs::ENSEMBL_SERVERROOT/gramene-live/conf";
  my $gramene_httpd   = $gramene_confdir.'/httpd.conf';
  open( HTTPD, $gramene_httpd );
  foreach(<HTTPD>){
    chomp;
    if(/^PerlSetVar/){
      my( $directive, $key, $value ) = split(/\s+/, $_, 3);
      $SiteDefs::PerlSetVar{$key} = $value;
    }
  }
  close( HTTPD );
  # Get the gramene_version from gramene.conf
  my $gramene_httpd2 = $gramene_confdir.'/gramene.conf';
  open( HTTPD, $gramene_httpd2 );
  while(<HTTPD>){
    chomp;
    if(/\<gramene\>/){
      while(<HTTPD>){
        chomp;
        if(/version\s+(\S.+)/){
          $SiteDefs::PerlSetVar{gramene_version} = $1;
          last;
        }
        if(/\<\\gramene\>/){
          warn( "[WARN] Cannot find <gramene> version in $gramene_httpd2\n");
          last;
        }
      }
      last;
    }
  }
  close( HTTPD );
  $SiteDefs::PerlSetVar{NavConf} = $gramene_confdir."/navbar.conf";

}

1;
