# $Id: Build.PL,v 1.11.2.2 2007/06/14 19:04:09 kclark Exp $

=head1 NAME

Build.PL

=head1 SYNOPSIS

  $ perl Build.PL
  $ su
  # ./Build install

=head1 DESCRIPTION

This is the installer script for Gramene.  It uses the Module::Build module
from CPAN.  You may need to install this module before being able to build
Gramene.

=cut

# ----------------------------------------------------

use strict;
use GrameneBuilder;

eval { require Module::Build };
if ( $@ =~ /Can't locate/ ) {
    print qq[Please install "Module::Build" before continuing.\n];
    exit(0);
}

my $builder = GrameneBuilder->new(
    create_readme         => 0,
    dist_abstract         => 'A comparative mapping resource',
    dist_author           => 'Gramene <gramene@gramene.org>',
    dist_name             => 'gramene',
    dist_version          => '25.0.0',
    license               => 'gpl',
    script_files          => [],
    sign                  => 0,
    requires => {
        'Apache'                                    => '0',
        'Apache::Cookie'                            => '1.3',
        'Apache::Request'                           => '0',
        'Authen::Captcha'                           => '1.023',
        'Basset::CGI'                               => '0',
        'Basset::Encryption::ProgressiveRotational' => '0',
        'Basset::Encryption::WeakKey'               => '0',
        'Basset::Extractor'                         => '0',
        'Basset::Object'                            => '0',
        'Basset::Template'                          => '0',
        'BerkeleyDB'                                => '0',
        'Bio::Seq'                                  => '0',
        'Boulder::Stream'                           => '0',
        'CAM::PDF'                                  => '0',
        'CGI'                                       => '3.07',
        'CGI::Ajax'                                 => '0.695',
        'CGI::Carp'                                 => '1.03',
        'CGI::Cookie'                               => '0',
        'Cache::Cache'                              => '1.03',
        'Carp'                                      => '0',
        'Class::Base'                               => '0.03',
        'Class::DBI'                                => '3.000014',
        'Class::DBI::AsForm'                        => '2.42',
        'Class::DBI::FromForm'                      => '0.04',
        'Class::DBI::Pager'                         => '0.080',
        'Class::DBI::Plugin::AbstractCount'         => '0.06',
        'Class::DBI::Plugin::RetrieveAll'           => '1.02',
        'Class::DBI::Sweet'                         => '0.080',
        'Config::General'                           => '2.27',
        'Cwd'                                       => '0',
        'DBD::mysql'                                => '0',
        'DBI'                                       => '1.52',
        'Data::Dumper'                              => '0',
        'Data::Page'                                => '0',
        'Data::Pageset'                             => '1.01',
        'Date::Calc'                                => '5.4',
        'Date::Format'                              => '2.22',
        'DateTime'                                  => '0.30',
        'Digest::MD5'                               => '2.33',
        'Email::Valid'                              => '0',
        'Exporter'                                  => '0',
        'FAQ::OMatic::dispatch'                     => '0',
        'File::Temp'                                => '0',
        'GD'                                        => '2.19',
        'GD::Graph::pie'                            => '0',
        'Geo::Coordinates::DecimalDegrees'          => '0.05',
        'Getopt::Long'                              => '2.34',
        'Getopt::Std'                               => '1.05',
        'Graph::Directed'                           => '0',
        'HTML::HeadParser'                          => '0',
        'HTML::GMap'                                => '0',
        'HTML::LinkExtractor'                       => '0.13',
        'HTML::Lint'                                => '0',
        'HTML::SearchPage'                          => '0',
        'HTML::Strip'                               => '0',
        'HTTP::Request::Common'                     => '1.26',
        'IO::Prompt'                                => '0.099002',
        'IO::Scalar'                                => '2.105000',
        'LWP'                                       => '5.803',
        'LWP::Simple'                               => '1.41',
        'LWP::UserAgent'                            => '2.033',
        'Lingua::EN::Inflect'                       => '1.88',
        'List::MoreUtils'                           => '0.15',
        'List::Util'                                => '1.17',
        'Log::Dispatch'                             => '2.16',
        'MLDBM'                                     => '2.01',
        'Mail::Sendmail'                            => '0.79',
        'Mail::SpamAssassin'                        => '3.001001',
        'Math::BigFloat'                            => '0',
        'Net::FTP'                                  => '2.75',
        'Number::Range'                             => '0.06',
        'PDF::API2'                                 => '0',
        'POSIX'                                     => '1.08',
        'Perl6::Say'                                => '0',
        'Perl6::Slurp'                              => '0',
        'Pod::Usage'                                => '1.3',
        'Readonly'                                  => '1.03',
        'Socket'                                    => '1.77',
        'Spreadsheet::WriteExcel'                   => '2.15',
        'String::Similarity'                        => '1.01',
        'Symbol'                                    => '1.05',
        'Template'                                  => '2.14',
        'Template::Constants'                       => '2.68',
        'Template::Plugin::Perl'                    => '0',
        'Test::More'                                => '0.62',
        'Text::Autoformat'                          => '0',
        'Text::ParseWords'                          => '3.22',
        'Text::RecordParser'                        => '1.002001',
        'Text::RecordParser::Tab'                   => '0',
        'Text::TabularDisplay'                      => '1.21',
        'Tie::IxHash'                               => '1.21',
        'Time::Format'                              => '1.00',
        'Time::ParseDate'                           => '2003.1126',
        'Time::Seconds'                             => '0',
        'WWW::Mechanize::Timed'                     => '0',
        'XML::Simple'                               => '2.12',
    },
);

my $tarball = $builder->dist_dir . '.tar.gz';

$builder->add_to_cleanup( $tarball );

$builder->create_build_script;

print "Now run './Build' and './Build install'\n";
exit(0);

# ----------------------------------------------------

=pod 

=head1 COPYRIGHT

Copyright (c) 2006 Cold Spring Harbor Laboratory

=head1 AUTHOR

Ken Youens-Clark E<lt>kclark@cshl.orgE<gt>.

=cut
