/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.sequence.SequenceFetcher;
import jadex.xml.XMLUtilities;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class SequenceXMLFetcher
implements SequenceFetcher {
    private Document document = null;
    private Element root = null;

    public SequenceXMLFetcher() {
    }

    public SequenceXMLFetcher(String file) {
        FileInputStream source = null;
        try {
            source = new FileInputStream(file);
        }
        catch (IOException e) {
            System.err.println("SequenceXMLFetcher.init(): " + e);
        }
        this.setSource(source);
    }

    public SequenceXMLFetcher(InputStream input) {
        this.setSource(input);
    }

    public SequenceXMLFetcher(InputStream input, String saxdriver) {
        this.setSource(input, saxdriver);
    }

    public void setSource(InputStream input) {
        SAXBuilder builder = new SAXBuilder(false);
        try {
            this.document = builder.build(input);
        }
        catch (JDOMException e) {
            System.err.println("SequenceXMLFetcher.setSource(): " + (Object)((Object)e));
        }
        try {
            input.close();
        }
        catch (IOException iOException) {}
        this.root = this.document.getRootElement();
    }

    public void setSource(InputStream input, String saxdriver) {
        SAXBuilder builder = new SAXBuilder(saxdriver, false);
        try {
            this.document = builder.build(input);
        }
        catch (JDOMException e) {
            System.err.println("SequenceXMLFetcher.setSource(): " + (Object)((Object)e));
        }
        try {
            input.close();
        }
        catch (IOException iOException) {}
        this.root = this.document.getRootElement();
    }

    public Element getRoot() {
        if (this.root.getName().equalsIgnoreCase("Chromosome")) {
            Element range = null;
            Namespace ns = Namespace.getNamespace((String)this.root.getNamespaceURI());
            range = this.root.getChild("Range", ns);
            if (range == null) {
                Element sub = this.root.getChild("Subsequence", ns);
                List list = sub.getChildren("Sequence", ns);
                Element last = (Element)list.get(list.size() - 1);
                long[] pos = XMLUtilities.getPositions(last, ns);
                range = new Element("Range", ns);
                range.addAttribute("start", "1");
                range.addAttribute("end", pos[1] + "");
                range.addAttribute("length", pos[1] + "");
                this.root.addChild(range);
            }
        }
        return this.root;
    }

    public Document getDocument() {
        return this.document;
    }

    public Namespace getNamespace() {
        Namespace ns = null;
        if (this.root != null) {
            ns = Namespace.getNamespace((String)this.root.getNamespaceURI());
        }
        return ns;
    }

    public void setDocument(Document doc) {
        this.document = doc;
        this.root = this.document.getRootElement();
    }
}

