/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.sequence.IndividualSequenceView;
import jadex.swing.sequence.SequenceViewFactory;
import jadex.swing.sequence.SequenceXMLFetcher;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JApplet;
import javax.swing.JFrame;

public class SequenceViewApplet
extends JApplet {
    private final String saxdriver = "org.brownell.xml.aelfred2.SAXDriver";
    private SequenceViewFactory viewFactory = null;

    public void init() {
        this.viewFactory = new SequenceViewFactory(this);
        IndividualSequenceView.setApplet(this);
        String name = null;
        String chromosome = null;
        try {
            name = this.getParameter("sequence");
            chromosome = this.getParameter("chromosome");
        }
        catch (Exception exception) {
            chromosome = "Chromosome_I";
        }
        if (chromosome == null) {
            chromosome = "Chromosome_I";
        }
        this.setSequence(chromosome, name);
    }

    public void start() {
        super.start();
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        System.out.println("Memory: total " + total + " used " + (total - free) + " free " + free);
    }

    public void stop() {
        this.viewFactory.clear();
        this.viewFactory = null;
        this.getContentPane().removeAll();
        this.gc();
    }

    private void gc() {
        try {
            System.gc();
            Thread.currentThread();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.currentThread();
            Thread.sleep(100L);
            System.gc();
            Thread.currentThread();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSequence(String chromosome, String name) {
        SequenceXMLFetcher fetcher = new SequenceXMLFetcher(this.getInputStream(chromosome.toLowerCase()), "org.brownell.xml.aelfred2.SAXDriver");
        this.viewFactory.setSequenceFetcher(fetcher);
        this.viewFactory.search(name);
    }

    private InputStream getInputStream(String name) {
        JarURLConnection jarConnection = null;
        try {
            try {
                URL jarUrl = this.getCodeBase();
                URL url = new URL("jar:" + jarUrl.toString() + name + ".jar!/");
                jarConnection = (JarURLConnection)url.openConnection();
                JarFile file = jarConnection.getJarFile();
                JarEntry entry = file.getJarEntry(String.valueOf(name) + ".xml");
                InputStream inputStream = file.getInputStream(entry);
                Object var8_16 = null;
                jarConnection = null;
                return inputStream;
            }
            catch (IOException e) {
                System.err.println("SequenceViewApplet.getInputStream(): " + e);
                InputStream inputStream = null;
                Object var8_17 = null;
                jarConnection = null;
                return inputStream;
            }
            catch (NullPointerException nullPointerException) {
                try {
                    JarFile file = new JarFile(String.valueOf(name) + ".jar");
                    JarEntry entry = file.getJarEntry(String.valueOf(name) + ".xml");
                    InputStream inputStream = file.getInputStream(entry);
                    Object var8_18 = null;
                    jarConnection = null;
                    return inputStream;
                }
                catch (IOException e2) {
                    System.err.println("SequenceViewApplet.getInputStream(): " + e2);
                    InputStream inputStream = null;
                    Object var8_19 = null;
                    jarConnection = null;
                    return inputStream;
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_20 = null;
            jarConnection = null;
            throw throwable;
        }
    }

    public static void main(String[] args) {
        SequenceViewApplet applet = new SequenceViewApplet();
        applet.init();
        applet.start();
        JFrame f = new JFrame("Applet View");
        f.addWindowListener(new 1());
        f.getContentPane().add((Component)applet, "Center");
        ((Component)f).setSize(1200, 800);
        ((Component)f).setVisible(true);
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }

        /* synthetic */ 1() {
        }
    }
}

