/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.sequence.SequenceSelectionEvent;
import jadex.swing.sequence.SequenceSelectionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class SequenceSelectionModel {
    private List selectionListeners = new ArrayList();
    private Element selectedElement = null;
    private List selection = new ArrayList();

    public void setSelectedElement(Element e) {
        this.selectedElement = e;
        this.selection.add(e);
        this.fireSelectionValueChanged(e, true);
    }

    public Element getSelectedElement() {
        return this.selectedElement;
    }

    public void setSelectedElements(List list) {
        this.selection = list;
        this.fireSelectionValueChanged(list, true);
    }

    public void deSelectedElements(List list) {
        this.selection.removeAll(list);
        this.fireSelectionValueChanged(list, false);
    }

    public void deSelectSequence(Element sequence) {
        if (this.selection.contains(sequence)) {
            this.selectedElement = sequence;
            this.selection.remove(sequence);
            this.fireSelectionValueChanged(sequence, false);
        }
    }

    public Element getSelected() {
        return this.selectedElement;
    }

    public void clearSelection() {
        if (this.selection.size() > 0) {
            this.deSelectedElements(this.selection);
        }
    }

    public void addSelectionListener(SequenceSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SequenceSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    protected void fireSelectionValueChanged(Element seq, boolean isSelected) {
        if (this.selectionListeners.size() == 0) {
            return;
        }
        SequenceSelectionEvent e = new SequenceSelectionEvent((Object)this, seq, isSelected);
        Iterator it = this.selectionListeners.iterator();
        while (it.hasNext()) {
            SequenceSelectionListener l = (SequenceSelectionListener)it.next();
            l.valueChanged(e);
        }
    }

    protected void fireSelectionValueChanged(List list, boolean isSelected) {
        if (this.selectionListeners.size() == 0) {
            return;
        }
        SequenceSelectionEvent e = new SequenceSelectionEvent((Object)this, list, isSelected);
        Iterator it = this.selectionListeners.iterator();
        while (it.hasNext()) {
            SequenceSelectionListener l = (SequenceSelectionListener)it.next();
            l.valueChanged(e);
        }
    }

    public List getSelection() {
        return this.selection;
    }

    public void setSelection(List list) {
        this.selection = list;
    }
}

