/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

public class SequenceRenderer
extends JPanel {
    private Color selectionForeground = Color.red;
    private Color selectionBackground = Color.orange;
    private Color background = Color.white;
    private Color foreground = Color.blue;
    private Color lineColor = Color.black;
    private boolean isPlus;
    private float xPadding = 1.0f;
    private float yPadding = 1.0f;
    private JLabel nameLabel = null;

    public SequenceRenderer() {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalGlue());
        this.nameLabel = new JLabel();
        Font font = this.nameLabel.getFont().deriveFont(10.0f);
        this.nameLabel.setFont(font);
        this.nameLabel.setHorizontalAlignment(0);
        this.nameLabel.setVerticalAlignment(0);
        this.add(this.nameLabel);
        this.add(Box.createHorizontalGlue());
    }

    public Component getSequenceRenderer(String name, long start, long end, boolean isSelected, boolean isFocused) {
        if (isSelected) {
            this.setBackground(this.selectionBackground);
            this.setForeground(this.selectionForeground);
        } else {
            this.setBackground(this.background);
            this.setForeground(this.foreground);
        }
        this.nameLabel.setText(name);
        this.isPlus = start - end <= 0L;
        return this;
    }

    public Component getSequenceRenderer(Element sequence, boolean isSelected, boolean isFocused) {
        Attribute att = sequence.getAttribute("name");
        String name = att.getValue();
        Namespace ns = sequence.getNamespace();
        Element range = sequence.getChild("Range", ns);
        if (range == null) {
            return null;
        }
        String start = range.getAttribute("start").getValue();
        String end = range.getAttribute("end").getValue();
        return this.getSequenceRenderer(name, Long.parseLong(start), Long.parseLong(end), isSelected, isFocused);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Dimension d2 = this.getSize();
        Insets insets = this.getInsets();
        float w = (float)((Dimension2D)d2).getWidth();
        float h = (float)((Dimension2D)d2).getHeight();
        g2.setPaint(this.getBackground());
        g2.fill(new Rectangle2D.Float(0.0f, 0.0f, w, h));
        if ((float)this.nameLabel.getWidth() > 3.0f * w) {
            this.nameLabel.setText("");
            return;
        }
        int labelX1 = this.nameLabel.getX();
        int labelX2 = labelX1 + this.nameLabel.getWidth();
        g2.setPaint(this.lineColor);
        g2.draw(new Line2D.Float(this.xPadding + (float)insets.left, h / 2.0f, (float)labelX1 - 2.0f, h / 2.0f));
        g2.draw(new Line2D.Float((float)labelX2 + 2.0f, h / 2.0f, w - this.xPadding - (float)insets.right, h / 2.0f));
        if (this.isPlus) {
            this.drawArrow(g2, new Point2D.Float(w - this.xPadding - (float)insets.right - 6.0f, h / 2.0f - 3.0f), new Point2D.Float(w - this.xPadding - (float)insets.right, h / 2.0f), new Point2D.Float(w - this.xPadding - (float)insets.right - 6.0f, h / 2.0f + 3.0f));
        } else {
            this.drawArrow(g2, new Point2D.Float(this.xPadding + (float)insets.left + 6.0f, h / 2.0f - 3.0f), new Point2D.Float(this.xPadding + (float)insets.left, h / 2.0f), new Point2D.Float(this.xPadding + (float)insets.left + 6.0f, h / 2.0f + 3.0f));
        }
    }

    private void drawArrow(Graphics2D g2, Point2D.Float point1, Point2D.Float point2, Point2D.Float point3) {
        g2.draw(new Line2D.Float(point1, point2));
        g2.draw(new Line2D.Float(point2, point3));
    }
}

