/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.sequence.SequenceFetcher;
import jadex.xml.XMLUtilities;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class SequenceModel {
    private SequenceFetcher fetcher = null;

    public SequenceModel() {
    }

    public SequenceModel(SequenceFetcher fetcher) {
        this.setFetcher(fetcher);
    }

    public void setFetcher(SequenceFetcher fetcher) {
        this.fetcher = fetcher;
    }

    public SequenceFetcher getFetcher() {
        return this.fetcher;
    }

    public boolean isLeaf(Element node) {
        List list = node.getChildren();
        return list == null || list.size() == 0;
    }

    public Element getRoot() {
        if (this.fetcher != null) {
            return this.fetcher.getRoot();
        }
        return null;
    }

    public Document getDocument() {
        if (this.fetcher != null) {
            return this.fetcher.getDocument();
        }
        return null;
    }

    public Namespace getNamespace() {
        if (this.fetcher != null) {
            return this.fetcher.getNamespace();
        }
        return null;
    }

    public Element search(String name) {
        Element root = this.getRoot();
        if (root == null) {
            return null;
        }
        String rootName = root.getAttributeValue("name");
        if (rootName.equalsIgnoreCase(name)) {
            return root;
        }
        1 comp = new 1();
        return this.search(root, name, comp);
    }

    private Element search(Element parent, String name, Comparator comp) {
        Element found = null;
        List list = XMLUtilities.getSubSequences(parent, this.getNamespace());
        if (list == null || list.size() == 0) {
            return null;
        }
        Collections.sort(list, comp);
        int index = this.foundElement(list, name, 0, list.size());
        if (index >= 0) {
            found = (Element)list.get(index);
        } else {
            Element par = null;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                par = (Element)it.next();
                found = this.search(par, name, comp);
                if (found != null) break;
            }
        }
        return found;
    }

    private int foundElement(List list, String key, int start, int end) {
        if (start == end) {
            return -1;
        }
        int index = (start + end) / 2;
        Element seq = (Element)list.get(index);
        String name = seq.getAttributeValue("name");
        int result = key.compareTo(name);
        if (result == 0) {
            return index;
        }
        if (result < 0) {
            return this.foundElement(list, key, start, index);
        }
        return this.foundElement(list, key, index + 1, end);
    }

    private final class 1
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            Element seq1 = (Element)obj1;
            Element seq2 = (Element)obj2;
            String name1 = seq1.getAttributeValue("name");
            name1 = name1.toLowerCase();
            String name2 = seq2.getAttributeValue("name");
            name2 = name2.toLowerCase();
            return name1.compareTo(name2);
        }

        /* synthetic */ 1() {
        }
    }
}

