/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.map.MapRange;
import jadex.swing.sequence.GeneRenderer;
import jadex.swing.sequence.SequenceLayoutModel;
import jadex.swing.sequence.SequenceModel;
import jadex.swing.sequence.SequenceRenderer;
import jadex.swing.sequence.SequenceSelectionModel;
import jadex.swing.sequence.SequenceUI;
import jadex.swing.sequence.SequenceXMLFetcher;
import jadex.xml.XMLUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import org.jdom.Element;

public class SequenceDisplay
extends JComponent
implements Scrollable {
    private SequenceRenderer renderer = null;
    private GeneRenderer geneRenderer = null;
    private SequenceModel model = null;
    private SequenceSelectionModel selectionModel = null;
    private SequenceLayoutModel layoutModel = null;
    private JPopupMenu popup = null;

    public SequenceDisplay() {
    }

    public SequenceDisplay(SequenceModel model) {
        this.setModel(model);
    }

    public void setModel(SequenceModel model) {
        SequenceModel old = this.model;
        this.model = model;
        this.firePropertyChange("SequenceModel", old, this.model);
    }

    public SequenceModel getModel() {
        return this.model;
    }

    public void setRenderer(SequenceRenderer renderer) {
        this.renderer = renderer;
    }

    public SequenceRenderer getRenderer() {
        return this.renderer;
    }

    public void setGeneRenderer(GeneRenderer renderer) {
        this.geneRenderer = renderer;
    }

    public GeneRenderer getGeneRenderer() {
        return this.geneRenderer;
    }

    public void setUI(SequenceUI ui) {
        super.setUI(ui);
    }

    public SequenceUI getUI() {
        return (SequenceUI)this.ui;
    }

    public void updateUI() {
        SequenceUI ui = new SequenceUI();
        this.setUI(ui);
        this.invalidate();
    }

    public void clear() {
        super.removeAll();
        this.getUI().uninstallUI(this);
        this.model = null;
        this.selectionModel.clearSelection();
        this.selectionModel = null;
    }

    public void setPopup(JPopupMenu pop) {
        this.add(pop);
        this.popup = pop;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public void setSelectionModel(SequenceSelectionModel model) {
        this.selectionModel = model;
    }

    public SequenceSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setLayoutModel(SequenceLayoutModel model) {
        this.layoutModel = model;
    }

    public SequenceLayoutModel getLayoutModel() {
        return this.layoutModel;
    }

    public void setSelectedSequence(Element sequence) {
        if (this.selectionModel != null) {
            this.selectionModel.setSelectedElement(sequence);
        }
    }

    public void setSelectedSequences(List list) {
        if (this.selectionModel != null) {
            this.selectionModel.setSelectedElements(list);
        }
    }

    public Element getSelectedSequence() {
        if (this.selectionModel != null) {
            return this.selectionModel.getSelectedElement();
        }
        return null;
    }

    public List getSelectedSequences() {
        if (this.selectionModel == null) {
            return null;
        }
        return this.selectionModel.getSelection();
    }

    public void deSelectSequence(Element sequence) {
        if (this.selectionModel != null) {
            this.selectionModel.deSelectSequence(sequence);
        }
    }

    public void clearSelection() {
        if (this.selectionModel != null) {
            this.selectionModel.clearSelection();
        }
    }

    public void setMapRange(MapRange range) {
        this.getLayoutModel().setMapRange(range);
    }

    public MapRange getMapRange() {
        return this.getLayoutModel().getMapRange();
    }

    public void setMouseAt(long p) {
        this.getLayoutModel().setMouseAt(p);
    }

    public void getMouseAt() {
        this.getLayoutModel().getMouseAt();
    }

    public void search(String name) {
        if (this.model == null) {
            return;
        }
        Element found = this.model.search(name);
        if (found == null) {
            return;
        }
        List selection = this.selectionModel.getSelection();
        if (!selection.contains(found)) {
            selection.add(found);
        } else {
            selection.remove(found);
            selection.add(found);
        }
        this.setSelectedSequences(selection);
        this.setMapRange(XMLUtilities.getMapRange(found, found.getNamespace()));
    }

    public void firePropertyChange(String name, Object oldValue, Object newValue) {
        super.firePropertyChange(name, oldValue, newValue);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage java SequenceDisplay xmlFile");
            System.exit(0);
        }
        JFrame f = new JFrame("Sequence Display");
        f.addWindowListener(new 1(f));
        SequenceDisplay display = new SequenceDisplay();
        display.updateUI();
        f.getContentPane().add((Component)new JScrollPane(display), "Center");
        ((Component)f).setSize(1024, 350);
        ((Component)f).setVisible(true);
        SequenceXMLFetcher fetcher = new SequenceXMLFetcher(args[0]);
        SequenceModel model = new SequenceModel(fetcher);
        display.setModel(model);
        display.search("C01F4");
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle p1, int p2, int p3) {
        if (p2 == 1) {
            return (int)this.layoutModel.height;
        }
        return p3;
    }

    public int getScrollableBlockIncrement(Rectangle p1, int p2, int p3) {
        if (p2 == 1) {
            return p1.height;
        }
        return p1.width;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    private static final class 1
    extends WindowAdapter {
        private final /* synthetic */ JFrame val$f;

        public void windowClosing(WindowEvent e) {
            ((Component)this.val$f).setVisible(false);
            this.val$f.dispose();
            System.exit(0);
        }

        /* synthetic */ 1(JFrame val$f) {
            this.val$f = val$f;
        }
    }
}

