/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jade.db.AceObject;
import jadex.swing.map.MapRange;
import jadex.swing.map.UnknownPositionException;

public class Contig {
    private String name = null;
    private MapRange extend = null;
    private MapRange pMap = null;
    private MapRange extendF = null;
    private String map = null;
    private AceObject obj = null;
    private float k = Float.MAX_VALUE;
    private float b = Float.MAX_VALUE;

    public Contig() {
    }

    public Contig(String name) {
        this.setName(name);
    }

    public Contig(String name, String map) {
        this.setName(name);
        this.setMap(map);
    }

    public Contig(String name, String map, MapRange ext, MapRange pm) {
        this(name, map);
        this.setExtend(ext);
        this.setPMap(pm);
    }

    public MapRange getRangeFromPMap(MapRange p) {
        if (this.k == Float.MAX_VALUE) {
            this.calculateKB();
        }
        MapRange r = null;
        try {
            float start = this.k * (float)p.getStart() + this.b;
            float end = this.k * (float)p.getEnd() + this.b;
            r = new MapRange(start, end);
        }
        catch (UnknownPositionException e) {
            System.err.println("Contig.getRangeFromPMap(): " + e);
        }
        return r;
    }

    private void calculateKB() {
        if (this.extend == null || this.pMap == null) {
            throw new UnsupportedOperationException("Contig.calculate()");
        }
        try {
            this.k = (this.extend.getStartF() - this.extend.getEndF()) / (this.pMap.getStartF() - this.pMap.getEndF());
            this.b = this.extend.getStartF() - this.pMap.getStartF() * this.k;
        }
        catch (UnknownPositionException e) {
            System.err.println("Contig.calculate: " + e);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setMap(String map) {
        this.map = map;
    }

    public String getMap() {
        return this.map;
    }

    public void setExtend(MapRange r) {
        this.extend = r;
    }

    public MapRange getExtend() {
        return this.extend;
    }

    public void setExtendF(MapRange r) {
        this.extendF = r;
    }

    public MapRange getExtendF() {
        return this.extendF;
    }

    public void setPMap(MapRange r) {
        this.pMap = r;
    }

    public MapRange getPMap() {
        return this.pMap;
    }

    public void setAceObject(AceObject o) {
        this.obj = o;
    }

    public AceObject getAceObject() {
        return this.obj;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.name != null) {
            buf.append("Name: Contig : " + this.name + "\n");
        }
        if (this.map != null) {
            buf.append("Map: " + this.map + "\n");
        }
        if (this.extend != null) {
            buf.append("Extend: " + this.extend.toString() + "\n");
        }
        if (this.extendF != null) {
            buf.append("ExtendF: " + this.extendF.toString() + "\n");
        }
        if (this.pMap != null) {
            buf.append("PMap: " + this.pMap.toString() + "\n");
        }
        if (this.obj != null) {
            buf.append("Obj: " + this.obj + "\n");
        }
        return buf.toString();
    }
}

