/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.sequence.Clone;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CloneUI
extends JComponent
implements MouseListener {
    private String name = null;
    private Clone clone = null;
    private Color MOUSE_IN_COLOR = Color.red;
    private Color MOUSE_OUT_COLOR;
    private Color foreColor = this.MOUSE_OUT_COLOR = Color.orange;

    public CloneUI() {
        this.initialize();
    }

    public CloneUI(String name) {
        this.setName(name);
        this.initialize();
    }

    public CloneUI(Clone c) {
        this.setClone(c);
        this.initialize();
    }

    private void initialize() {
        this.addMouseListener(this);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setClone(Clone c) {
        this.clone = c;
        this.setName(this.clone.getName());
        this.setToolTipText(String.valueOf(this.name) + ": " + this.clone.getMapRange());
    }

    public Clone getClone() {
        return this.clone;
    }

    public void setColor(Color c) {
        this.foreColor = c;
        this.repaint();
    }

    public Color getColor() {
        return this.foreColor;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Dimension d2 = this.getSize();
        double w = ((Dimension2D)d2).getWidth();
        double h = ((Dimension2D)d2).getHeight();
        g2.setPaint(this.foreColor);
        g2.fill(new Rectangle2D.Double(0.0, 0.0, w, h));
    }

    public void mouseReleased(MouseEvent p1) {
    }

    public void mouseEntered(MouseEvent p1) {
        this.setColor(this.MOUSE_IN_COLOR);
    }

    public void mouseClicked(MouseEvent p1) {
    }

    public void mousePressed(MouseEvent p1) {
    }

    public void mouseExited(MouseEvent p1) {
        this.setColor(this.MOUSE_OUT_COLOR);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("CloneUI Tester");
        f.addWindowListener(new 1());
        JPanel p = new JPanel();
        p.setBackground(Color.white);
        p.setLayout(null);
        CloneUI ui = new CloneUI();
        ui.setColor(Color.blue);
        p.add(ui);
        ui.setBounds(50, 50, 1, 50);
        f.getContentPane().add((Component)p, "Center");
        ((Component)f).setSize(200, 200);
        ((Component)f).setVisible(true);
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }

        /* synthetic */ 1() {
        }
    }
}

