/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.classView.MapViewContainer;
import jadex.swing.classView.SequenceMapView;
import jadex.swing.map.MapControl;
import jadex.swing.map.MapRange;
import jadex.swing.sequence.CloneControl;
import jadex.swing.sequence.CloneDisplay;
import jadex.swing.sequence.FileCloneFetcher;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class CloneOpenFileAction
implements ActionListener {
    MapViewContainer container = null;
    SequenceMapView view = null;

    public CloneOpenFileAction() {
    }

    public CloneOpenFileAction(MapViewContainer container) {
        this.container = container;
    }

    public CloneOpenFileAction(MapViewContainer c, SequenceMapView v) {
        this.setContainer(c);
        this.setMapView(v);
    }

    public void setContainer(MapViewContainer c) {
        this.container = c;
    }

    public void setMapView(SequenceMapView v) {
        this.view = v;
    }

    public void actionPerformed(ActionEvent p1) {
        if (this.container == null) {
            return;
        }
        JFileChooser chooser = new JFileChooser("/forte4j/Development");
        int returnVal = chooser.showOpenDialog((Component)this.container);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            String full = file.getAbsolutePath();
            FileCloneFetcher fetcher = new FileCloneFetcher(full);
            fetcher.fetchClone();
            MapRange r = fetcher.getMapScale();
            CloneDisplay display = new CloneDisplay();
            CloneControl control = new CloneControl(display);
            display.setRange(r);
            control.setCloneFetcher(fetcher);
            control.setMapRange(r);
            display.setCloneControl(control);
            MapControl mapControl = new MapControl();
            mapControl.setMap(r);
            mapControl.addPropertyChangeListener((PropertyChangeListener)((Object)control));
            control.setMapControl(mapControl);
            String name = fetcher.getMapName();
            this.container.setTitle(String.valueOf(this.container.getTitle()) + name);
            this.container.showControlPanel(true);
            this.container.setLeftMapScale(true);
            this.container.setRightMapScale(true);
            this.container.setMapControl(mapControl);
            this.container.addPanel(new String("Clone Display"), (JPanel)display);
        }
    }
}

