/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.map.MapRange;
import jadex.swing.sequence.Clone;
import jadex.swing.sequence.Contig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class CloneFetcher {
    private String name = null;
    private MapRange map = null;
    protected static final String link = "_";
    private Map clones = null;
    private Map ctgs = null;

    public void fetchClone() {
        String str = this.getCloneInfor();
        this.getClone(str);
    }

    public abstract String getCloneInfor();

    protected void getClone(String str) {
        try {
            BufferedReader reader = new BufferedReader(new StringReader(str));
            this.clones = new HashMap();
            String line = null;
            this.name = reader.readLine().trim();
            while ((line = reader.readLine()) != null) {
                if (line.trim().equalsIgnoreCase(String.valueOf(this.name) + link + "contig")) {
                    this.readContig(reader);
                    continue;
                }
                if (line.trim().equalsIgnoreCase(String.valueOf(this.name) + link + "contig" + link + "clone")) {
                    this.readContigClone(reader, this.clones);
                    continue;
                }
                if (line.trim().equalsIgnoreCase(String.valueOf(this.name) + link + "clone")) {
                    this.readClone(reader, this.clones);
                    continue;
                }
                if (!line.trim().equalsIgnoreCase(String.valueOf(this.name) + link + "infor")) continue;
                this.readSequenceInfor(reader);
            }
        }
        catch (IOException e) {
            System.err.println("CloneFetcher.getClone(): " + e);
        }
    }

    private void readContig(BufferedReader r) {
        String line = null;
        this.ctgs = new HashMap();
        try {
            while ((line = r.readLine().trim()) != null && line.length() != 0) {
                LineInfor infor;
                Contig ctg = new Contig();
                ctg.setName(line);
                line = r.readLine();
                if (line.startsWith("Format")) {
                    line = r.readLine();
                }
                if (line.indexOf(this.name) == -1) {
                    infor = this.parseLine(line);
                    ctg.setExtendF(infor.range);
                    line = r.readLine();
                }
                infor = this.parseLine(line);
                ctg.setExtend(infor.range);
                line = r.readLine();
                if (line.startsWith("//")) {
                    line = r.readLine();
                }
                if (line.startsWith("Format")) {
                    line = r.readLine();
                }
                infor = this.parseLine(line);
                ctg.setPMap(infor.range);
                this.ctgs.put(ctg.getName(), ctg);
                r.readLine();
            }
        }
        catch (IOException e) {
            System.err.println("CloneFetcher.readContig(): " + e);
        }
    }

    private void readContigClone(BufferedReader reader, Map clones) {
        String line = null;
        try {
            while ((line = reader.readLine()) != null && line.length() != 0) {
                if (line.indexOf("Format") > -1 || line.startsWith("//")) continue;
                LineInfor infor = this.parseLine(line);
                Clone clone = new Clone(infor.str1, infor.range, (Contig)this.ctgs.get(infor.str2));
                clones.put(clone.getName(), clone);
            }
        }
        catch (IOException e) {
            System.err.println("CloneFetcher.readContigClone(): " + e);
        }
    }

    private void readClone(BufferedReader reader, Map clones) {
        String line = null;
        try {
            while ((line = reader.readLine().trim()) != null && line.length() != 0) {
                if (line.startsWith("Format") || line.startsWith("//")) continue;
                LineInfor infor = this.parseLine(line);
                if (clones.containsKey(infor.str1)) continue;
                Clone clone = new Clone(infor.str1, infor.range);
                clones.put(clone.getName(), clone);
            }
        }
        catch (IOException e) {
            System.err.println("CloneFetcher.readClone(): " + e);
        }
    }

    private void readSequenceInfor(BufferedReader reader) {
        try {
            reader.readLine();
            String line = reader.readLine();
            LineInfor infor = this.parseLine(line);
            this.map = infor.range;
            reader.readLine();
        }
        catch (IOException e) {
            System.err.println("CloneFetcher.readSequenceInfor(): " + e);
        }
    }

    private LineInfor parseLine(String line) {
        MapRange r;
        LineInfor rtn = new LineInfor();
        StringTokenizer tokenizer = new StringTokenizer(line);
        if (tokenizer.countTokens() == 3) {
            rtn.str1 = tokenizer.nextToken();
        } else if (tokenizer.countTokens() == 4) {
            rtn.str1 = tokenizer.nextToken();
            rtn.str2 = tokenizer.nextToken();
        }
        String left = tokenizer.nextToken();
        String right = tokenizer.nextToken();
        rtn.range = r = new MapRange(left, right);
        return rtn;
    }

    public Map getClone() {
        return this.clones;
    }

    public String getMapName() {
        return this.name;
    }

    public Map getContig() {
        return this.ctgs;
    }

    public MapRange getMapScale() {
        return this.map;
    }

    private class LineInfor {
        String str1;
        String str2;
        MapRange range;

        LineInfor() {
        }
    }
}

