/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.map.DisplayControl;
import jadex.swing.map.DisplayModel;
import jadex.swing.map.DisplayPopup;
import jadex.swing.map.DownKnob;
import jadex.swing.map.Knob;
import jadex.swing.map.LineMouse;
import jadex.swing.map.LocusLayout;
import jadex.swing.map.LocusUI;
import jadex.swing.map.MapPointDisplay;
import jadex.swing.map.MapRange;
import jadex.swing.map.SmartLocusLayout;
import jadex.swing.map.UnknownPositionException;
import jadex.swing.map.UpKnob;
import jadex.swing.sequence.Clone;
import jadex.swing.sequence.CloneControl;
import jadex.swing.sequence.FileCloneFetcher;
import jadex.swing.util.Magnifier;
import jadex.swing.util.Zoomable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CloneDisplay
extends JPanel
implements MapPointDisplay,
Zoomable,
MouseListener {
    private CloneControl control = null;
    private List clones = null;
    private List assClones = null;
    private LocusUI[] names = null;
    private MapRange range = null;
    private boolean cShown = true;
    private String mouseInName = null;
    private final float xPadding = 10.0f;
    private final float yPadding = 10.0f;
    private final float CLONE_WIDTH = 10.0f;
    private final int TOTAL_COLUMN = 4;
    private float rel;
    private float offset;
    private float verticalP;
    private Rectangle2D.Float zoom = null;
    private Knob upKnob = null;
    private Knob downKnob = null;
    private DisplayPopup pop = null;
    private LocusLayout layout = null;
    private LocusLayout columnLayout = null;
    private LocusLayout smartLayout = null;
    private Magnifier mag = null;

    public CloneDisplay() {
        this.initialize();
    }

    public CloneDisplay(CloneControl control) {
        this.initialize();
        this.setCloneControl(control);
    }

    public CloneDisplay(DisplayModel model) {
        this.initialize();
        this.setClones(Arrays.asList(model.getData()));
    }

    private void initialize() {
        super.setLayout(null);
        super.addMouseListener(this);
        this.setKnobs();
        this.mag = new Magnifier((Zoomable)this);
        this.columnLayout = new LocusLayout(10.0f, DisplayControl.NUMBER_PER_COLUMN, this.cShown, Color.lightGray);
        this.smartLayout = new SmartLocusLayout(10.0f, DisplayControl.NUMBER_PER_COLUMN, this.cShown, Color.lightGray);
        this.layout = this.columnLayout;
    }

    public DisplayPopup getPopup() {
        return this.pop;
    }

    private void setKnobs() {
        this.upKnob = new UpKnob();
        this.downKnob = new DownKnob();
        this.add((Component)this.upKnob);
        this.add((Component)this.downKnob);
        this.upKnob.setBounds(0, 0, 10, 10);
        this.downKnob.setBounds(0, 0, 10, 10);
        if (this.control != null) {
            this.control.setKnobs(this.upKnob, this.downKnob);
            this.upKnob.setDisplayControl((DisplayControl)this.control);
            this.downKnob.setDisplayControl((DisplayControl)this.control);
        }
    }

    public void setCloneControl(CloneControl ctl) {
        this.control = ctl;
        this.pop = new DisplayPopup((MapPointDisplay)this, (DisplayControl)this.control, "clone");
        this.setClones(this.control.getClones());
        this.assClones = this.control.getAssignedClones();
        this.verticalP = 10.0f * (float)(this.assClones.size() + 1);
        this.mag.setVerTicalPosition(this.verticalP);
        this.control.setKnobs(this.upKnob, this.downKnob);
        this.upKnob.setDisplayControl((DisplayControl)this.control);
        this.downKnob.setDisplayControl((DisplayControl)this.control);
    }

    public void setClones(List list) {
        this.clones = list;
    }

    public void setRange(MapRange r) {
        this.range = r;
        this.repaint();
    }

    public void setNameLayout(LocusLayout l) {
        this.layout = l;
        this.layout.setLocusUI(this.names);
        this.repaint();
    }

    public void setNameLayout(String name) {
        if (name.equalsIgnoreCase("columnLayout")) {
            this.setNameLayout(this.columnLayout);
        } else if (name.equalsIgnoreCase("smartLayout")) {
            this.setNameLayout(this.smartLayout);
        }
    }

    public void setConnectShown(boolean b) {
        this.cShown = b;
        this.columnLayout.setConnect(b);
        this.smartLayout.setConnect(b);
        this.repaint();
    }

    public boolean isConnectShown() {
        return this.cShown;
    }

    public void setShowNames(LocusUI[] l) {
        this.names = l;
        this.removeAll();
        this.add((Component)this.upKnob);
        this.add((Component)this.downKnob);
        if (this.names != null && this.names.length > 0) {
            int i = 0;
            while (i < this.names.length) {
                this.add((Component)this.names[i]);
                this.names[i].setBounds(0, 0, 40, 10);
                this.names[i].addMouseListener((MouseListener)new LineMouse(this.names[i], (MapPointDisplay)this));
                ++i;
            }
        }
        this.layout.setLocusUI(this.names);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Dimension d2 = this.getSize();
        float w = (float)((Dimension2D)d2).getWidth();
        float h = (float)((Dimension2D)d2).getHeight();
        try {
            this.offset = this.range.getEndF();
            this.rel = (h - 20.0f) / this.range.getExtendF();
        }
        catch (UnknownPositionException e) {
            System.err.println("CloneDisplay.paintComponent(): " + e);
        }
        g2.setPaint(Color.white);
        g2.fill(new Rectangle2D.Float(0.0f, 0.0f, w, h));
        this.drawClones(g2, h);
        this.drawChromosome(g2, h);
        this.layout.drawNames(this.verticalP + 5.0f, h, this.offset, this.rel, g2);
        if (this.zoom != null) {
            g2.setPaint(Color.blue);
            g2.draw(this.zoom);
        }
    }

    private void drawClones(Graphics2D g2, float h) {
        if (this.assClones != null) {
            Clone clone = null;
            float x = 0.0f;
            Iterator it = this.assClones.iterator();
            while (it.hasNext()) {
                List clones = (List)it.next();
                x += 10.0f;
                Iterator iter = clones.iterator();
                while (iter.hasNext()) {
                    clone = (Clone)iter.next();
                    this.drawClone(clone, g2, x, h);
                }
            }
        }
    }

    private void drawClone(Clone clone, Graphics2D g2, float x, float h) {
        MapRange range = clone.getMapRange();
        try {
            float s = range.getStartF();
            float e = range.getEndF();
            float p = clone.getPosition();
            float start = (this.offset - s) * this.rel + 10.0f;
            float end = (this.offset - e) * this.rel + 10.0f;
            float pos = (this.offset - p) * this.rel + 10.0f;
            if (pos < 10.0f || pos > h - 10.0f) {
                return;
            }
            if (clone.getName().equalsIgnoreCase(this.mouseInName)) {
                g2.setPaint(Color.red);
                g2.draw(new Line2D.Float(x, start, x, end));
                g2.setPaint(Color.red);
                g2.draw(new Line2D.Float(x, pos, this.verticalP + 5.0f, pos));
            } else {
                g2.setPaint(Color.orange);
                g2.draw(new Line2D.Float(x, start, x, end));
                g2.setPaint(Color.black);
                g2.draw(new Line2D.Float(this.verticalP - 5.0f, pos, this.verticalP + 5.0f, pos));
            }
        }
        catch (UnknownPositionException e) {
            System.err.println("CloneDisplay.drawClone(): " + e);
        }
    }

    private void drawChromosome(Graphics2D g2, float h) {
        float x = this.verticalP;
        g2.setColor(Color.lightGray);
        g2.draw(new Line2D.Float(x, 10.0f, x, h - 10.0f));
        this.upKnob.setBounds((int)(x - 4.0f), 2, 8, 8);
        this.downKnob.setBounds((int)(x - 4.0f), (int)(h - 10.0f), 8, 8);
    }

    public float getVerticalPosition() {
        return this.verticalP;
    }

    public void setZoom(Rectangle2D.Float zoom) {
        this.zoom = zoom;
    }

    public void doZooming() {
        if (this.zoom != null) {
            float inY = (float)this.zoom.getMinY();
            float outY = (float)this.zoom.getMaxY();
            float start = this.offset - (outY - 10.0f) / this.rel;
            float end = this.offset - (inY - 10.0f) / this.rel;
            MapRange r1 = new MapRange(start, end);
            if (this.control != null) {
                this.control.zoom(r1);
            } else {
                this.setRange(r1);
            }
            this.zoom = null;
        }
    }

    public void mouseReleased(MouseEvent p1) {
        if (p1.isPopupTrigger()) {
            this.doPopup(p1);
        }
    }

    public void mouseEntered(MouseEvent p1) {
    }

    public void mouseClicked(MouseEvent p1) {
    }

    public void mousePressed(MouseEvent p1) {
        if (p1.isPopupTrigger()) {
            this.doPopup(p1);
        }
    }

    public void mouseExited(MouseEvent p1) {
    }

    private void doPopup(MouseEvent e) {
        if (this.pop != null) {
            this.pop.show(this, e.getX(), e.getY());
        }
    }

    public static void main(String[] args) {
        FileCloneFetcher fetcher = new FileCloneFetcher("sequence_map_I");
        fetcher.fetchClone();
        CloneDisplay display = new CloneDisplay();
        CloneControl control = new CloneControl(display);
        MapRange r = new MapRange(0L, 7867L);
        display.setRange(r);
        control.setCloneFetcher(fetcher);
        control.setMapRange(r);
        display.setCloneControl(control);
        JFrame f = new JFrame("Clone Display: Chromosome I");
        f.addWindowListener(new 1());
        f.getContentPane().add((Component)new JScrollPane(display), "Center");
        display.setSize(400, 600);
        ((Component)f).setSize(400, 600);
        ((Component)f).setVisible(true);
    }

    public LocusLayout getNameLayout() {
        return this.layout;
    }

    public void setMouseInName(String name) {
        this.mouseInName = name;
        this.repaint();
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }

        /* synthetic */ 1() {
        }
    }
}

