/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jade.db.AceAccessor;
import jade.db.JSAceAccessor;
import jadex.swing.map.MapRange;
import jadex.swing.sequence.Clone;
import jadex.swing.sequence.CloneFetcher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AceDBCloneFetcher
extends CloneFetcher {
    private String name = null;
    private JSAceAccessor accessor = null;

    public AceDBCloneFetcher() {
    }

    public AceDBCloneFetcher(String host, int port, String name) {
        this.name = name;
        this.accessor = new JSAceAccessor(host, port);
    }

    public AceDBCloneFetcher(JSAceAccessor ace, String name) {
        this.name = name;
        this.accessor = ace;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setAccessor(JSAceAccessor ace) {
        this.accessor = ace;
    }

    public AceAccessor getAccessor() {
        return this.accessor;
    }

    public String getCloneInfor() {
        String query = null;
        String result = null;
        StringBuffer buf = new StringBuffer();
        buf.append(this.name + "\n");
        query = new String("aql -h select a->contig from a in object(\"map\", \"" + this.name + "\")");
        this.accessor.write(query);
        result = this.accessor.read();
        String[] ctgs = this.getContigs(result);
        this.getContigInfor(ctgs, buf);
        buf.append("\n");
        this.getContigCloneInfor(ctgs, buf);
        buf.append("\n");
        this.getCloneInfor(buf);
        buf.append("\n");
        this.getChromInfor(buf);
        return buf.toString();
    }

    private void getContigInfor(String[] ctgs, StringBuffer buf) {
        buf.append(this.name + "_" + "contig\n");
        String query = null;
        String result = null;
        int i = 0;
        while (i < ctgs.length) {
            buf.append(ctgs[i] + "\n");
            query = new String("aql -h select m, m[Left], m[Right] from m in object(\"Contig\", \"" + ctgs[i] + "\")->Map");
            this.accessor.write(query);
            result = this.accessor.read();
            buf.append(result + "\n");
            query = new String("aql -h select \"Pmap\", m[0], m[1] from m in object(\"Contig\", \"" + ctgs[i] + "\")->pMap");
            this.accessor.write(query);
            result = this.accessor.read();
            buf.append(result + "\n");
            ++i;
        }
    }

    private String[] getContigs(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str, "\n");
        ArrayList<String> list = new ArrayList<String>();
        String token = null;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken().trim();
            if (token.startsWith("Format") || token.startsWith(new String("//"))) continue;
            list.add(token);
        }
        return list.toArray(new String[0]);
    }

    private void getContigCloneInfor(String[] ctgs, StringBuffer buf) {
        buf.append(this.name + "_" + "contig" + "_" + "clone\n");
        String query = null;
        String result = null;
        int i = 0;
        while (i < ctgs.length) {
            query = new String("aql -h @clones := select a->clone from a in object(\"contig\", \"" + ctgs[i] + "\") ; select c:1, m[0], m[1], m[2] from c in @clones, m in c:1->Pmap");
            this.accessor.write(query);
            result = this.accessor.read();
            buf.append(result + "\n");
            ++i;
        }
    }

    private void getCloneInfor(StringBuffer buf) {
        buf.append(this.name + "_" + "clone");
        String query = new String("aql -h @clones := select a->clone from a in object(\"map\", \"" + this.name + "\" ) ; select c:1, m[Left], m[Right] from c in @clones, m in c:1->map");
        this.accessor.write(query);
        String result = this.accessor.read();
        buf.append(result + "\n");
    }

    private void getChromInfor(StringBuffer buf) {
        buf.append(this.name + "_" + "infor\n");
        String query = new String("aql -h select \"extent\", a[0], a[1] from a in object(\"map\", \"" + this.name + "\")->Extent");
        this.accessor.write(query);
        String result = this.accessor.read();
        buf.append(result + "\n");
    }

    public static void main(String[] args) {
        MapRange r;
        Map ctg;
        if (args.length != 3) {
            System.out.println("USage java AceDBCloneFetcher host port sequence_map");
            System.exit(0);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        String obj = args[2];
        AceDBCloneFetcher fetcher = new AceDBCloneFetcher(host, port, obj);
        long start = System.currentTimeMillis();
        fetcher.fetchClone();
        long end = System.currentTimeMillis();
        System.out.println("Time used to processing the data: " + (end - start));
        Map map = fetcher.getClone();
        System.out.println("Clone nummber: " + map.size());
        if (map != null) {
            Set keys = map.keySet();
            String name = null;
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                name = (String)iterator.next();
                Clone clone = (Clone)map.get(name);
                System.out.println(clone.toString());
            }
        }
        if ((ctg = fetcher.getContig()) != null) {
            System.out.println("Contig number: " + ctg.size());
        }
        if ((r = fetcher.getMapScale()) != null) {
            System.out.println("Map extent: " + r.toString());
        }
    }
}

