/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jadex.swing.map.UnknownPositionException;

public class MapRange {
    private long start = Long.MAX_VALUE;
    private long end = Long.MAX_VALUE;
    private float startF = Float.POSITIVE_INFINITY;
    private float endF = Float.POSITIVE_INFINITY;
    private long extend;

    public MapRange() {
    }

    public MapRange(long start, long end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public MapRange(float startF, float endF) {
        this.setStartF(startF);
        this.setEndF(endF);
    }

    public MapRange(String left, String right) {
        try {
            int start = Integer.parseInt(left);
            int end = Integer.parseInt(right);
            this.setStart(start);
            this.setEnd(end);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                float startF = Float.parseFloat(left);
                float endF = Float.parseFloat(right);
                this.setStartF(startF);
                this.setEndF(endF);
            }
            catch (NumberFormatException e1) {
                System.err.println("MapRange.init(): " + e1);
            }
        }
    }

    public void setStart(long s) {
        this.start = s;
        this.startF = s;
    }

    public void setEnd(long e) {
        this.end = e;
        this.endF = e;
    }

    public long getStart() throws UnknownPositionException {
        if (this.start == Long.MAX_VALUE) {
            throw new UnknownPositionException();
        }
        return this.start;
    }

    public long getEnd() throws UnknownPositionException {
        if (this.end == Long.MAX_VALUE) {
            throw new UnknownPositionException();
        }
        return this.end;
    }

    public long getExtend() throws UnknownPositionException {
        if (this.start == Long.MAX_VALUE || this.end == Long.MAX_VALUE) {
            throw new UnknownPositionException();
        }
        long diff = this.end - this.start;
        if (diff >= 0L) {
            return diff + 1L;
        }
        return diff - 1L;
    }

    public float getExtendF() throws UnknownPositionException {
        if ((float)this.start == Float.POSITIVE_INFINITY || (float)this.end == Float.POSITIVE_INFINITY) {
            throw new UnknownPositionException();
        }
        return this.endF - this.startF;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Start: " + this.start);
        buffer.append("    ");
        buffer.append("End: " + this.end);
        return buffer.toString();
    }

    public String toStringF() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Start: " + this.startF);
        buffer.append(" ");
        buffer.append("End: " + this.endF);
        return buffer.toString();
    }

    public boolean equals(MapRange rg) {
        boolean rtn = false;
        try {
            if (this.getStart() == rg.getStart() && this.getEnd() == rg.getEnd()) {
                rtn = true;
            }
        }
        catch (UnknownPositionException e) {
            System.out.println(e);
        }
        return rtn;
    }

    public boolean equalsF(MapRange rg) {
        boolean rtn = false;
        try {
            if (this.getStartF() == rg.getStartF() && this.getEndF() == rg.getEndF()) {
                rtn = true;
            }
        }
        catch (UnknownPositionException e) {
            System.out.println(e);
        }
        return rtn;
    }

    public float getStartF() throws UnknownPositionException {
        if (this.startF == Float.POSITIVE_INFINITY) {
            throw new UnknownPositionException();
        }
        return this.startF;
    }

    public float getEndF() throws UnknownPositionException {
        if (this.endF == Float.POSITIVE_INFINITY) {
            throw new UnknownPositionException();
        }
        return this.endF;
    }

    public void setStartF(float start) {
        this.startF = start;
        this.start = (long)start;
    }

    public void setEndF(float end) {
        this.endF = end;
        this.end = (long)end;
    }

    public boolean intersect(MapRange r) {
        boolean rtn = true;
        try {
            float start1 = r.getStart();
            float end1 = r.getEnd();
            if ((float)this.end <= start1 || (float)this.start >= end1) {
                rtn = false;
            }
        }
        catch (UnknownPositionException e) {
            System.err.println("MapRange.intersect: " + e);
        }
        return rtn;
    }

    public MapRange zoomIn(int step) {
        long extend = (this.end - this.start) / (long)step;
        return new MapRange(this.start + extend, this.end - extend);
    }

    public MapRange zoomOut(int step) {
        long extend = (this.end - this.start) / (long)step;
        return new MapRange(this.start - extend, this.end + extend);
    }

    public MapRange moveUp(int step) {
        long extend = (this.end - this.start) / (long)step;
        return new MapRange(this.start + extend, this.end + extend);
    }

    public MapRange moveDown(int step) {
        long extend = (this.end - this.start) / (long)step;
        return new MapRange(this.start - extend, this.end - extend);
    }

    public boolean contain(long value) {
        if (this.start < this.end) {
            return value >= this.start && value <= this.end;
        }
        return value >= this.end && value <= this.start;
    }

    public MapRange combine(MapRange range1) {
        if (range1 == null) {
            return new MapRange(this.start, this.end);
        }
        long start1 = this.start;
        long end1 = this.end;
        if (start1 > end1) {
            start1 = this.end;
            end1 = this.start;
        }
        long start2 = 0L;
        long end2 = 0L;
        try {
            start2 = range1.getStart();
            end2 = range1.getEnd();
            if (start2 > end2) {
                start2 = range1.getEnd();
                end2 = range1.getStart();
            }
        }
        catch (UnknownPositionException e) {
            System.err.println("MapRange.combine(): " + e);
        }
        long s = start1 >= start2 ? start2 : start1;
        long e = end1 <= end2 ? end2 : end1;
        return new MapRange(s, e);
    }

    public long getLeftEnd() {
        if (this.start < this.end) {
            return this.start;
        }
        return this.end;
    }

    public long getRightEnd() {
        if (this.start < this.end) {
            return this.end;
        }
        return this.start;
    }
}

