/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jadex.swing.classView.MapView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class OpenFileAction
implements ActionListener {
    private JFrame frame = null;
    private File file = null;
    private Object[][] marker;
    private Object[][] locus;
    private Object[][] interval;
    private String title = null;
    private int locusLength;
    private int intervalLength;
    private Vector markers;
    private Vector loci;
    private Vector intervals;
    private MapView view = null;
    private boolean debug = false;
    private boolean debug1 = false;

    public OpenFileAction() {
    }

    public OpenFileAction(JFrame f, MapView view) {
        this.frame = f;
        this.view = view;
    }

    public void actionPerformed(ActionEvent p1) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File("/home/wgm/java/forte4j/Development"));
        int returnVal = chooser.showOpenDialog(this.frame);
        if (returnVal == 0) {
            this.file = chooser.getSelectedFile();
            if (this.debug) {
                System.out.println(this.file.getName());
            }
            this.processFile(this.file);
            this.processView();
        }
    }

    private void processView() {
        this.view.setMarker(this.getMarkers());
        this.view.setInterval(this.getIntervals());
        this.view.setLocus(this.getLoci());
        this.view.setFrame();
    }

    private void processFile(File file) {
        Vector content = null;
        this.markers = new Vector();
        this.loci = new Vector();
        this.intervals = new Vector();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            while (true) {
                line = reader.readLine();
                if (this.debug) {
                    System.out.println(line);
                }
                if (line != null && line.length() != 0) {
                    if (line.indexOf("Map") != -1) {
                        this.title = line;
                        this.view.setTitle("Map View: " + this.title);
                        continue;
                    }
                    if (line.indexOf("marker_length") != -1) {
                        content = this.markers;
                        continue;
                    }
                    if (line.indexOf("loci_length") != -1) {
                        this.getLocusLength(line);
                        content = this.loci;
                        continue;
                    }
                    if (line.indexOf("interval_length") != -1) {
                        this.getIntervalLength(line);
                        content = this.intervals;
                        continue;
                    }
                    content.addElement(line);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
        if (this.debug) {
            System.out.println("Locus length: " + this.loci.size());
        }
        this.marker = this.setMarker(this.markers);
        this.locus = this.setLoci(this.loci);
        if (this.debug) {
            System.out.println("Interval length: " + this.intervals.size());
        }
        this.setIntervals(this.intervals);
    }

    private void getLocusLength(String line) {
        int pos = new String("loci_length").length();
        String s = line.substring(pos).trim();
        this.locusLength = Integer.parseInt(s);
        if (this.debug) {
            System.out.println(s);
        }
    }

    private void getIntervalLength(String line) {
        int pos = new String("interval_length").length();
        String s = line.substring(pos).trim();
        this.intervalLength = Integer.parseInt(s);
        if (this.debug) {
            System.out.println(s);
        }
    }

    private Object[][] setMarker(Vector marker) {
        int size = marker.size();
        Object[][] os = new Object[size][2];
        String s = null;
        int i = 0;
        while (i < size) {
            s = (String)marker.elementAt(i);
            if (this.debug1) {
                System.out.println(s);
            }
            int pos = s.indexOf("  ");
            String name = s.substring(0, pos).trim();
            Float position = new Float(s.substring(pos).trim());
            os[i][0] = name;
            os[i][1] = position;
            ++i;
        }
        return os;
    }

    private Object[][] setLoci(Vector loci) {
        int size = loci.size();
        Object[][] os = new Object[size][3];
        String s = null;
        int i = 0;
        while (i < size) {
            s = (String)loci.elementAt(i);
            if (this.debug1) {
                System.out.println(s);
            }
            int pos1 = s.indexOf("  ");
            int pos2 = s.lastIndexOf("  ", s.length() - 1);
            String name = s.substring(0, pos1).trim();
            Float pos = new Float(s.substring(pos1, pos2).trim());
            Float error = new Float(s.substring(pos2).trim());
            os[i][0] = name;
            os[i][1] = pos;
            os[i][2] = error;
            ++i;
        }
        return os;
    }

    private void setIntervals(Vector intervals) {
        int size = intervals.size();
        this.interval = new Object[size][3];
        String s = null;
        int i = 0;
        while (i < size) {
            s = (String)intervals.elementAt(i);
            if (this.debug1) {
                System.out.println(s);
            }
            int pos1 = s.indexOf("  ");
            int pos2 = s.lastIndexOf("  ", s.length() - 1);
            String name = s.substring(0, pos1).trim();
            Float start = new Float(s.substring(pos1, pos2).trim());
            Float end = new Float(s.substring(pos2).trim());
            this.interval[i][0] = name;
            this.interval[i][1] = start;
            this.interval[i][2] = end;
            ++i;
        }
    }

    public Object[][] getMarkers() {
        return this.marker;
    }

    public Object[][] getLoci() {
        return this.locus;
    }

    public Object[][] getIntervals() {
        return this.interval;
    }
}

