/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jadex.swing.map.MapRange;
import jadex.swing.map.UnknownPositionException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class MapControl {
    private MapRange range;
    private MapRange map;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public MapControl() {
    }

    public MapControl(MapRange r) {
        this.map = r;
        this.range = r;
    }

    public void setMap(MapRange map) {
        this.map = map;
        if (this.range == null) {
            this.range = map;
        }
    }

    public MapRange getMap() {
        return this.map;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public MapRange getRange() {
        return this.range;
    }

    public void reset() {
        this.setRange(this.map);
    }

    public void movingUp() {
        MapRange r = this.range;
        try {
            float s = r.getStartF();
            float e = r.getEndF();
            float step = r.getExtendF() / 3.0f;
            MapRange rNew = new MapRange(s + step, e + step);
            this.setRange(rNew);
        }
        catch (UnknownPositionException e) {
            System.err.println(e);
        }
    }

    public void movingDown() {
        MapRange r = this.range;
        try {
            float s = r.getStartF();
            float e = r.getEndF();
            float step = r.getExtendF() / 3.0f;
            MapRange rNew = new MapRange(s - step, e - step);
            this.setRange(rNew);
        }
        catch (UnknownPositionException e) {
            System.err.println(e);
        }
    }

    public void setRange(MapRange range) {
        MapRange oldRange = this.range;
        this.range = range;
        if (oldRange != null && oldRange.equalsF(range)) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange("range", oldRange, range);
    }
}

