/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jade.db.AceObject;
import jadex.swing.OpenFrames;
import jadex.swing.map.Locus;
import jadex.swing.map.MapPoint;
import jadex.swing.map.UnknownPositionException;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;

public class LocusUI
extends JLabel
implements MouseListener {
    private AceObject locus = null;
    private float position;
    private float error = Float.MAX_VALUE;
    private String name;
    private boolean showName = false;
    private Color background = Color.white;
    private Color foreIn = Color.red;
    private Color foreOut = Color.black;
    private Color foreground = null;
    private boolean debug = false;
    private final String url = "http://www.wormbase.org/perl/ace/elegans/gene/locus?name=";

    public LocusUI() {
    }

    public LocusUI(MapPoint mapPoint) {
        AceObject aceObject;
        Object object;
        try {
            object = mapPoint.getName();
            float f = mapPoint.getPosition();
            this.error = mapPoint.getError();
            this.initialize((String)object, f);
        }
        catch (UnknownPositionException unknownPositionException) {
            System.err.println(unknownPositionException);
        }
        if (mapPoint instanceof Locus && (aceObject = ((Locus)(object = (Locus)mapPoint)).getAceObject()) != null) {
            this.setAceObject(((Locus)object).getAceObject());
        }
    }

    public LocusUI(String string, float f) {
        this.initialize(string, f);
    }

    public AceObject getAceObject() {
        return this.locus;
    }

    public Color getForOutColor() {
        return this.foreOut;
    }

    public String getName() {
        return this.name;
    }

    public float getPosition() {
        return this.position;
    }

    private void initialize(String string, float f) {
        this.addMouseListener(this);
        this.position = f;
        this.foreground = this.foreOut;
        super.setForeground(this.foreground);
        super.setFont(new Font("Dialog", 0, 9));
        this.setName(string);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.foreground = this.foreIn;
        super.setForeground(this.foreIn);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.foreground = this.foreOut;
        super.setForeground(this.foreOut);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.locus != null) {
            String string = "http://www.wormbase.org/perl/ace/elegans/gene/locus?name=" + this.name;
            if (!OpenFrames.getInstance().show(string, this.name)) {
                OpenFrames.getInstance().show(this.locus);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void setAceObject(AceObject aceObject) {
        this.locus = aceObject;
    }

    public void setForeOutColor(Color color) {
        if (this.foreOut == color) {
            return;
        }
        this.foreOut = color;
        this.setForeground(color);
    }

    public void setName(String string) {
        this.name = string;
        super.setText(string);
        if (this.error == Float.MAX_VALUE) {
            this.setToolTipText(String.valueOf(string) + " " + this.getPosition());
        } else {
            this.setToolTipText(String.valueOf(string) + " " + this.getPosition() + " " + this.error);
        }
    }

    public void setPosition(float f) {
        this.position = f;
    }
}

