/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jadex.swing.map.LocusUI;
import jadex.swing.map.MapPoint;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class LocusLayout {
    float yPadding;
    int NUMBER_PER_COLUMN;
    boolean cShown;
    Color cColor;
    LocusUI[] lUI = null;
    String mouseInName = null;
    Comparator comp = new Comparator(){

        public int compare(Object object, Object object2) {
            LocusUI locusUI = (LocusUI)object;
            LocusUI locusUI2 = (LocusUI)object2;
            String string = locusUI.getName();
            String string2 = locusUI2.getName();
            Float f = new Float(locusUI.getPosition());
            Float f2 = new Float(locusUI2.getPosition());
            int n = f2.compareTo(f);
            return n != 0 ? n : string2.compareTo(string);
        }

        public boolean equals(Object object, Object object2) {
            MapPoint mapPoint = (MapPoint)object;
            MapPoint mapPoint2 = (MapPoint)object2;
            String string = mapPoint.getName();
            String string2 = mapPoint2.getName();
            return string.equalsIgnoreCase(string2);
        }
    };

    LocusLayout(float f, int n, boolean bl, Color color) {
        this.yPadding = f;
        this.NUMBER_PER_COLUMN = n;
        this.cShown = bl;
        this.cColor = color;
    }

    private void doSorting() {
        this.sortOnColumn();
    }

    protected void drawNames(float f, float f2, float f3, float f4, Graphics2D graphics2D) {
        if (this.lUI == null) {
            return;
        }
        int n = this.lUI.length;
        float f5 = f + 15.0f;
        float f6 = this.yPadding - 2.0f;
        float f7 = (f2 - 2.0f * this.yPadding) / (float)(this.NUMBER_PER_COLUMN - 1);
        int n2 = 0;
        int n3 = (int)((float)n / (float)this.NUMBER_PER_COLUMN + 0.95f);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < this.NUMBER_PER_COLUMN) {
                if (n2 == n) {
                    return;
                }
                this.lUI[n2].setBounds((int)f5, (int)f6, 40, 10);
                if (this.cShown) {
                    float f8 = this.lUI[n2].getPosition();
                    float f9 = (f3 - f8) * f4 + this.yPadding;
                    if (this.mouseInName != null && this.lUI[n2].getName().equals(this.mouseInName)) {
                        graphics2D.setColor(Color.red);
                    } else {
                        graphics2D.setColor(this.cColor);
                    }
                    graphics2D.draw(new Line2D.Float(f - 10.0f, f9, f5, f6 + 5.0f));
                }
                f6 += f7;
                ++n2;
                ++n5;
            }
            f5 += 40.0f;
            f6 = this.yPadding - 2.0f;
            ++n4;
        }
    }

    public String getName() {
        return new String("columnLayout");
    }

    protected void setConnect(boolean bl) {
        this.cShown = bl;
    }

    protected void setLocusUI(LocusUI[] locusUIArray) {
        this.lUI = locusUIArray;
        this.doSorting();
    }

    protected void setMouseInName(String string) {
        this.mouseInName = string;
    }

    private void sortOnColumn() {
        int n = this.lUI.length;
        int n2 = (int)((float)n / (float)this.NUMBER_PER_COLUMN + 0.95f);
        List<LocusUI> list = Arrays.asList(this.lUI);
        int n3 = 0;
        int n4 = 1;
        while (n4 <= n2) {
            int n5 = n3 + this.NUMBER_PER_COLUMN;
            if (n5 > n) {
                n5 = n;
            }
            List<LocusUI> list2 = list.subList(n3, n5);
            Collections.sort(list2, this.comp);
            n3 = n5;
            ++n4;
        }
    }
}

