/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jadex.swing.map.LocusControl;
import jadex.swing.map.LocusDisplay;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

public class LocusDisplayPopup
extends JPopupMenu {
    private LocusControl control;
    private LocusDisplay display;
    private JMenuItem more;
    private JMenuItem less;
    private JMenuItem reset;
    private JRadioButton columnLayout;
    private JRadioButton smartLayout;
    private int count = 0;

    public LocusDisplayPopup(LocusDisplay display, LocusControl control) {
        this.display = display;
        this.control = control;
        this.setLayoutMenu();
        this.setLineMenu();
        this.setShowNumberMenu();
        this.setZoomMenu();
        this.setSearchMenu();
    }

    private void setLayoutMenu() {
        JMenu layoutMenu = new JMenu("Set layout");
        this.columnLayout = new JRadioButton("column Layout");
        this.columnLayout.setSelected(true);
        this.smartLayout = new JRadioButton("Smart Layout");
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.columnLayout);
        bg.add(this.smartLayout);
        layoutMenu.setFont(new Font("Dialog", 0, 11));
        this.columnLayout.setFont(new Font("Dialog", 0, 11));
        this.smartLayout.setFont(new Font("Dialog", 0, 11));
        ActionListener l1 = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LocusDisplayPopup.this.display.setLocusLayout("columnLayout");
            }
        };
        ActionListener l2 = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LocusDisplayPopup.this.display.setLocusLayout("smartLayout");
            }
        };
        this.columnLayout.addActionListener(l1);
        this.smartLayout.addActionListener(l2);
        layoutMenu.add(this.columnLayout);
        layoutMenu.add(this.smartLayout);
        this.add(layoutMenu);
        this.add(new JSeparator());
    }

    private void setLineMenu() {
        final JMenuItem line = new JMenuItem("Hide Lines");
        line.setFont(new Font("Dialog", 0, 11));
        line.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean cShown = LocusDisplayPopup.this.display.isConnectShown();
                if (cShown) {
                    LocusDisplayPopup.this.display.setConnectShown(false);
                    line.setText("Show Lines");
                } else {
                    LocusDisplayPopup.this.display.setConnectShown(true);
                    line.setText("Hide Lines");
                }
            }
        });
        this.add(line);
        this.add(new JSeparator());
    }

    private void setShowNumberMenu() {
        this.more = new JMenuItem("Show more...");
        this.less = new JMenuItem("Show less...");
        this.reset = new JMenuItem("Reset");
        this.more.setFont(new Font("Dialog", 0, 11));
        this.more.setActionCommand("more");
        this.less.setFont(new Font("Dialog", 0, 11));
        this.less.setActionCommand("less");
        this.reset.setFont(new Font("Dialog", 0, 11));
        this.reset.setActionCommand("reset");
        ActionListener a = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command.equalsIgnoreCase("more")) {
                    LocusDisplayPopup.this.control.showMore();
                    LocusDisplayPopup.this.count++;
                } else if (command.equalsIgnoreCase("less")) {
                    LocusDisplayPopup.this.control.showLess();
                    LocusDisplayPopup.this.count--;
                } else if (command.equalsIgnoreCase("reset")) {
                    LocusDisplayPopup.this.control.showReset();
                    LocusDisplayPopup.this.count = 0;
                }
                LocusDisplayPopup.this.checkShowMenu();
            }
        };
        this.more.addActionListener(a);
        this.less.addActionListener(a);
        this.less.setEnabled(false);
        this.reset.addActionListener(a);
        this.reset.setEnabled(false);
        this.add(this.more);
        this.add(this.less);
        this.add(this.reset);
        this.add(new JSeparator());
    }

    protected void checkShowMenu() {
        int totalShow = this.control.getTotalShowNumber();
        int showNumber = this.control.getShowNumber();
        int number_per_column = LocusControl.NUMBER_PER_COLUMN;
        if (showNumber < totalShow) {
            if (showNumber > number_per_column) {
                this.less.setEnabled(true);
                this.more.setEnabled(true);
                if (this.count == 0) {
                    this.reset.setEnabled(false);
                } else {
                    this.reset.setEnabled(true);
                }
            } else if (showNumber == number_per_column) {
                this.less.setEnabled(false);
                this.more.setEnabled(true);
                this.reset.setEnabled(false);
            } else if (showNumber < number_per_column) {
                this.less.setEnabled(false);
                this.more.setEnabled(true);
                this.reset.setEnabled(true);
            }
        } else if (totalShow > number_per_column) {
            this.more.setEnabled(false);
            this.less.setEnabled(true);
            this.reset.setEnabled(true);
        } else if (totalShow <= number_per_column) {
            this.more.setEnabled(false);
            this.less.setEnabled(false);
            this.reset.setEnabled(false);
        }
        if (showNumber < 10) {
            this.smartLayout.doClick();
        } else {
            this.columnLayout.doClick();
        }
    }

    private void setZoomMenu() {
        JMenuItem zoomout = new JMenuItem("Zoom out");
        zoomout.setFont(new Font("Dialog", 0, 11));
        zoomout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LocusDisplayPopup.this.control.reset();
            }
        });
        this.add(zoomout);
        this.add(new JSeparator());
    }

    private void setSearchMenu() {
        JMenuItem search = new JMenuItem("Search Loci");
        search.setFont(new Font("Dialog", 0, 11));
        JMenuItem deSearch = new JMenuItem("DeSearch");
        deSearch.setFont(new Font("Dialog", 0, 11));
        search.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String pattern = JOptionPane.showInputDialog(LocusDisplayPopup.this.display, "Search for ... in this range", "Locus Search", 1);
                if (pattern != null && pattern.length() != 0) {
                    LocusDisplayPopup.this.control.doSearch(pattern);
                }
            }
        });
        deSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LocusDisplayPopup.this.control.deSearch();
            }
        });
        this.add(search);
        this.add(deSearch);
    }
}

