/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jade.db.AceObject;
import jadex.swing.map.MapPoint;
import jadex.swing.map.UnknownPositionException;

public class Locus
implements MapPoint {
    private String name = null;
    private float position = Float.MAX_VALUE;
    private float error = Float.MAX_VALUE;
    private AceObject locus = null;

    public Locus() {
    }

    public Locus(String string, float f) {
        this.setName(string);
        this.setPosition(f);
    }

    public Locus(String string, float f, AceObject aceObject) {
        this.setName(string);
        this.setPosition(f);
        if (aceObject != null) {
            this.setAceObject(aceObject);
        }
    }

    public Locus(String string, float f, float f2, AceObject aceObject) {
        this.setName(string);
        this.setPosition(f);
        this.setError(f2);
        this.setAceObject(aceObject);
    }

    public Locus(AceObject aceObject) {
        this.setAceObject(aceObject);
    }

    public void setAceObject(AceObject aceObject) {
        this.locus = aceObject;
    }

    public AceObject getAceObject() {
        return this.locus;
    }

    public float getPosition() throws UnknownPositionException {
        if (this.position == Float.MAX_VALUE) {
            AceObject aceObject = this.locus.get("Position");
            if (aceObject == null) {
                throw new UnknownPositionException(this.locus.name + " position unknown");
            }
            float f = Float.parseFloat(aceObject.name());
            return f;
        }
        return this.position;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.locus.name();
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPosition(float f) {
        this.position = f;
    }

    public void setError(float f) {
        this.error = f;
    }

    public float getError() {
        return this.error;
    }
}

