/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jade.db.AceObject;
import jadex.swing.OpenFrames;
import jadex.swing.map.MapControl;
import jadex.swing.map.MapRange;
import jadex.swing.map.UnknownPositionException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class IntervalUI
extends JComponent
implements MouseListener {
    private float start;
    private float end;
    private float w;
    private float h;
    private String name;
    private MapRange range = null;
    private Color background = Color.white;
    private Color forIn = Color.red;
    private Color forOut = Color.black;
    private Color foreground = null;
    private FontMetrics fontM = null;
    private LineMetrics lineM = null;
    private Font deFont = null;
    private AceObject interval = null;
    private MapControl control = null;
    private JPopupMenu pop = null;
    private final String url = "http://www.wormbase.org/perl/ace/elegans/misc/etree?class=Rearrangement&name=";

    public IntervalUI() {
    }

    public IntervalUI(float start, float end, String name) {
        this.setStart(start);
        this.setEnd(end);
        this.range = new MapRange(start, end);
        this.setName(name);
        this.initialize();
    }

    public IntervalUI(AceObject o) {
        this.interval = o;
        try {
            this.range = this.getRange(o);
            this.setStart(this.range.getStartF());
            this.setEnd(this.range.getEndF());
        }
        catch (UnknownPositionException e) {
            System.out.println("Position unknown: " + e);
            return;
        }
        this.setName(o.name());
        this.initialize();
    }

    private void initialize() {
        this.setPopup();
    }

    public void setAceObject(AceObject o) {
        this.interval = o;
    }

    public void setMapControl(MapControl c) {
        this.control = c;
    }

    private void setPopup() {
        this.pop = new JPopupMenu();
        JMenuItem zoom = new JMenuItem("Zoom in this interval");
        zoom.setFont(new Font("Dialog", 0, 11));
        zoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (IntervalUI.this.control != null) {
                    IntervalUI.this.control.setRange(IntervalUI.this.range);
                    IntervalUI.this.setBackground(Color.orange);
                }
            }
        });
        this.pop.add(zoom);
    }

    private MapRange getRange(AceObject o) throws UnknownPositionException {
        AceObject left = o.get("Left");
        AceObject right = o.get("Right");
        if (left == null || right == null) {
            throw new UnknownPositionException();
        }
        float start = Float.parseFloat(left.right().name());
        float end = Float.parseFloat(right.right().name());
        return new MapRange(start, end);
    }

    public void setStart(float start) {
        this.start = start;
    }

    public float getStart() {
        return this.start;
    }

    public void setEnd(float end) {
        this.end = end;
    }

    public float getEnd() {
        return this.end;
    }

    public void setName(String name) {
        this.name = name;
        this.setToolTipText(name + " " + this.range.toStringF());
        this.foreground = this.forOut;
        this.addMouseListener(this);
        this.deFont = new Font("Monospace", 0, 8);
    }

    public String getName() {
        return this.name;
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.pop.show(this, e.getX(), e.getY());
            return;
        }
        if (this.interval != null) {
            String s = "http://www.wormbase.org/perl/ace/elegans/misc/etree?class=Rearrangement&name=" + this.name;
            if (!OpenFrames.getInstance().show(s, this.name)) {
                OpenFrames.getInstance().show(this.interval);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.pop.show(this, e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.foreground = this.forIn;
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.foreground = this.forOut;
        this.repaint();
    }

    public boolean intersect(IntervalUI iu) {
        float start1 = iu.getStart();
        float end1 = iu.getEnd();
        return !(this.end <= start1) && !(this.start >= end1);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.removeAll();
        Graphics2D g2d = (Graphics2D)g;
        Dimension d = this.getSize();
        this.w = d.width;
        this.h = d.height;
        g2d.setColor(this.background);
        g2d.fill(new Rectangle2D.Float(0.0f, 0.0f, this.w, this.h));
        g2d.setColor(this.foreground);
        g2d.draw(new Line2D.Float(this.w / 2.0f, 5.0f, this.w / 2.0f, this.h - 5.0f));
        g2d.draw(new Line2D.Float(this.w / 2.0f - 5.0f, 5.0f, this.w / 2.0f + 5.0f, 5.0f));
        g2d.draw(new Line2D.Float(this.w / 2.0f - 5.0f, this.h - 5.0f, this.w / 2.0f + 5.0f, this.h - 5.0f));
        g2d.setFont(this.deFont);
        this.drawVerticalString(this.name, g2d, this.w / 2.0f + 2.0f, 7.0f);
    }

    private void drawVerticalString(String s, Graphics2D g2d, float x, float y) {
        char[] sarray = s.toCharArray();
        float fy = y;
        int i = 0;
        while (i < sarray.length) {
            char[] c = new char[]{sarray[i]};
            this.lineM = this.deFont.getLineMetrics(c, 0, 1, g2d.getFontRenderContext());
            float h = this.lineM.getHeight();
            g2d.drawString(sarray[i] + "", x, fy += h);
            ++i;
        }
    }

    public void setBackground(Color b) {
        if (b.equals(this.background)) {
            return;
        }
        this.background = b;
        this.repaint();
    }

    public void resetBackground() {
        this.setBackground(Color.white);
    }
}

