/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jadex.swing.map.IntervalUI;
import jadex.swing.map.MapControl;
import jadex.swing.map.MapRange;
import jadex.swing.map.UnknownPositionException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JPanel;

public class IntervalPanel
extends JPanel {
    private Vector intervals = new Vector();
    private MapRange range = null;
    private float extend;
    private float offset;
    private boolean debug = true;

    public IntervalPanel() {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(15, 400));
    }

    public IntervalPanel(MapRange scale) {
        this();
        this.setRange(scale);
    }

    public void setMapControl(MapControl c) {
        IntervalUI ui = null;
        int i = 0;
        while (i < this.intervals.size()) {
            ui = (IntervalUI)this.intervals.elementAt(i);
            ui.setMapControl(c);
            ++i;
        }
    }

    public void setRange(MapRange r) {
        this.range = r;
        try {
            this.extend = this.range.getExtendF();
            this.offset = this.range.getEndF();
        }
        catch (UnknownPositionException e) {
            System.out.println("Position don't know: " + e);
        }
        this.repaint();
    }

    public void addInterval(IntervalUI interval) {
        this.intervals.addElement(interval);
        this.add(interval);
        interval.setBounds(0, 0, 10, 40);
    }

    public boolean checkAdding(IntervalUI iv) {
        boolean canBeAdded = true;
        IntervalUI ui = null;
        int i = 0;
        int size = this.intervals.size();
        while (i < size) {
            ui = (IntervalUI)this.intervals.elementAt(i);
            if (ui.intersect(iv)) {
                canBeAdded = false;
                break;
            }
            ++i;
        }
        return canBeAdded;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Dimension d = this.getSize();
        float w = (float)((Dimension2D)d).getWidth();
        float h = (float)((Dimension2D)d).getHeight();
        float rel = h / this.extend;
        if (rel > 1000.0f) {
            rel = 1000.0f;
        }
        g2d.setColor(Color.white);
        g2d.fill(new Rectangle2D.Float(0.0f, 0.0f, w, h));
        int i = 0;
        while (i < this.intervals.size()) {
            IntervalUI ui = (IntervalUI)this.intervals.elementAt(i);
            float s = (this.offset - ui.getStart()) * rel;
            float e = (this.offset - ui.getEnd()) * rel;
            ui.setBounds(0, (int)e, (int)w, (int)(s - e));
            ++i;
        }
    }

    public void resetBackground() {
        int size = this.intervals.size();
        IntervalUI ui = null;
        int i = 0;
        while (i < size) {
            ui = (IntervalUI)this.intervals.elementAt(i);
            ui.resetBackground();
            ++i;
        }
    }
}

