/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.classView;

import jade.db.AceObject;
import jadex.swing.MouseSenser;
import jadex.swing.ObjectLabel;
import jadex.swing.classView.ClassView;
import jadex.swing.classView.TreeClassView;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class TreeClassView
extends ClassView {
    private AceObject localObj = null;
    private JComponent tree = null;

    public TreeClassView() {
    }

    public TreeClassView(AceObject o) {
        this.setObject(o);
    }

    public void setObject(AceObject object) {
        this.localObj = object;
        this.tree = this.getJTreeView();
        this.setView(this.tree);
    }

    public AceObject getObject() {
        return this.localObj;
    }

    public JComponent getView() {
        return this.tree;
    }

    public void setView(JComponent comp) {
        this.tree = comp;
    }

    private JLabel getObjLabel(AceObject obj) {
        JLabel label = obj.isClass() ? new ObjectLabel(obj) : new JLabel(obj.name());
        return label;
    }

    private void appendToTree(AceObject obj, DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(this.getObjLabel(obj));
        root.add(node);
        if (obj.right() != null) {
            this.appendToTree(obj.right(), node);
        }
        if (obj.down() != null) {
            this.appendToTree(obj.down(), root);
        }
    }

    protected JComponent getJTreeView() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.getObjLabel(this.localObj));
        if (this.localObj.right() != null) {
            this.appendToTree(this.localObj.right(), root);
        }
        JTree tree = new JTree(root);
        tree.setCellRenderer(new AceObjectTreeRenderer());
        tree.setRowHeight(0);
        tree.setEnabled(true);
        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MouseActivator
        extends MouseAdapter
        implements MouseMotionListener {
            private final /* synthetic */ JTree val$tree;
            private final /* synthetic */ TreeClassView this$0;

            MouseActivator() {
                this.this$0 = this$0;
                this.val$tree = val$tree;
            }

            public void mouseDragged(MouseEvent e) {
            }

            public void mouseMoved(MouseEvent e) {
                this.localProcessMouseEvent(e);
            }

            public void mousePressed(MouseEvent e) {
                this.localProcessMouseEvent(e);
            }

            private void localProcessMouseEvent(MouseEvent e) {
                if (e.getSource() == this.val$tree) {
                    try {
                        JLabel label;
                        DefaultMutableTreeNode node;
                        Object obj;
                        TreePath path = this.val$tree.getPathForLocation(e.getX(), e.getY());
                        this.val$tree.setSelectionPath(path);
                        Object item = path.getLastPathComponent();
                        if (item instanceof DefaultMutableTreeNode && (obj = (node = (DefaultMutableTreeNode)item).getUserObject()) instanceof JLabel && (label = (JLabel)obj) instanceof ObjectLabel) {
                            ObjectLabel olabel = (ObjectLabel)label;
                            olabel.processMouseEvent(e);
                        }
                    }
                    catch (Exception ecp) {
                        return;
                    }
                }
            }
        }
        tree.addMouseListener(new MouseActivator(this, tree));
        tree.addMouseMotionListener(new MouseActivator(this, tree));
        return new JScrollPane(tree);
    }

    class AceObjectTreeRenderer
    implements TreeCellRenderer {
        AceObjectTreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JComponent label = null;
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object obj = node.getUserObject();
                label = (JLabel)obj;
            }
            if (hasFocus) {
                if (label instanceof ObjectLabel) {
                    label.setForeground(MouseSenser.IN_FOREGROUND_COLOR);
                }
            } else if (label instanceof ObjectLabel) {
                label.setForeground(MouseSenser.OUT_FOREGROUND_COLOR);
            }
            if (label instanceof ObjectLabel) {
                label.setToolTipText("Click to show detailed information");
            }
            return label;
        }
    }
}

