/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing;

import jadex.swing.AceDBFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ViewSettingPanel
extends JPanel {
    private JComboBox jComboBox1;
    private JTextField jTextField1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JButton jButton1;
    private JButton jButton2;
    private JComboBox box2;
    private AceDBFrame dbFrame = null;
    private Properties viewProp = null;
    private JFrame frame = null;
    private JTextArea details = null;
    private JPanel taPanel = null;
    private boolean showDetails = false;
    private final String propName = "jadex" + File.separator + "view.prop";

    public ViewSettingPanel() {
        this.initComponents();
        this.fillView();
        this.showPanel();
    }

    private void fillView() {
        String string = new String("jadex" + File.separator + "swing" + File.separator + "classView");
        String string2 = new String("jadex.swing.classView.");
        File file = new File(string);
        if (file.isDirectory()) {
            String[] stringArray = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.indexOf(".class") > -1;
                }
            });
            int n = 0;
            while (n < stringArray.length) {
                try {
                    int n2 = stringArray[n].indexOf(".class");
                    String string3 = stringArray[n].substring(0, n2);
                    String string4 = String.valueOf(string2) + string3;
                    Class<?> clazz = Class.forName(string4);
                    String string5 = clazz.getSuperclass().getName();
                    if (string5.equalsIgnoreCase(String.valueOf(string2) + "ClassView")) {
                        this.box2.addItem(string4);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println(classNotFoundException);
                }
                ++n;
            }
        }
    }

    public AceDBFrame getDbFrame() {
        return this.dbFrame;
    }

    private void initComponents() {
        this.jComboBox1 = new JComboBox();
        this.box2 = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setLayout(new GridBagLayout());
        this.jComboBox1.setEditable(true);
        this.jComboBox1.setFont(new Font("Dialog", 0, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jComboBox1, gridBagConstraints);
        this.box2.setEditable(true);
        this.box2.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.box2, gridBagConstraints);
        this.jLabel1.setText("Select Class");
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.insets = new Insets(25, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Input Or Select View Class (including package name)");
        this.jLabel2.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jButton1.setText("OK");
        this.jButton1.setFont(new Font("Dialog", 0, 12));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewSettingPanel.this.jButton1ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(10, 0, 25, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jButton1, gridBagConstraints);
        this.jButton2.setText("Show details");
        this.jButton2.setFont(new Font("Dialog", 0, 12));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewSettingPanel.this.jButton2ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(10, 0, 25, 0);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jButton2, gridBagConstraints);
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        this.setObjectView();
    }

    private void jButton2ActionPerformed(ActionEvent actionEvent) {
        if (this.showDetails) {
            this.taPanel.setVisible(false);
            this.jButton2.setText("Show details");
            this.showDetails = false;
        } else {
            this.taPanel.setVisible(true);
            this.jButton2.setText("Hide details");
            this.showDetails = true;
        }
        this.frame.doLayout();
        this.frame.pack();
        this.frame.validate();
        this.frame.repaint();
    }

    private void jTextField1ActionPerformed(ActionEvent actionEvent) {
        this.setObjectView();
    }

    public static void main(String[] stringArray) {
        ViewSettingPanel viewSettingPanel = new ViewSettingPanel();
    }

    public void setDbFrame(AceDBFrame aceDBFrame) {
        this.dbFrame = aceDBFrame;
        Vector vector = aceDBFrame.getNames();
        int n = 0;
        while (n < vector.size()) {
            this.jComboBox1.addItem(vector.elementAt(n));
            ++n;
        }
    }

    private void setObjectView() {
        this.viewProp = new Properties();
        String string = this.jComboBox1.getSelectedItem().toString();
        String string2 = this.box2.getSelectedItem().toString();
        try {
            File file = new File(this.propName);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            this.viewProp.load(fileInputStream);
            this.viewProp.setProperty(string, string2);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.viewProp.store(fileOutputStream, null);
            fileInputStream.close();
            fileOutputStream.close();
            this.updateProp();
        }
        catch (IOException iOException) {
            this.jTextField1.setText("Cannot set the view class.");
            this.jTextField1.requestFocus();
        }
    }

    private void showPanel() {
        this.frame = new JFrame();
        this.frame.setTitle("Class View Setting");
        this.frame.setResizable(false);
        this.setPreferredSize(new Dimension(350, 140));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.frame.getContentPane().add((Component)this, "North");
        this.details = new JTextArea();
        this.details.setEditable(false);
        this.taPanel = new JPanel();
        this.taPanel.setLayout(new BorderLayout());
        this.taPanel.setPreferredSize(new Dimension(350, 200));
        this.taPanel.setBorder(BorderFactory.createEtchedBorder());
        this.taPanel.add((Component)new JScrollPane(this.details), "Center");
        this.taPanel.setVisible(false);
        this.frame.getContentPane().add((Component)this.taPanel, "Center");
        this.frame.setDefaultCloseOperation(2);
        this.frame.pack();
        ((Component)this.frame).setVisible(true);
        this.updateProp();
    }

    public void updateProp() {
        block3: {
            File file = new File(this.propName);
            if (!file.exists()) break block3;
            try {
                this.details.setText("");
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    this.details.append(String.valueOf(string) + "\n");
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException);
                this.details.setText("");
                this.details.append(iOException.toString());
            }
        }
    }
}

