/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing;

import jade.db.AceObject;
import jadex.swing.ObjectViewController;
import java.applet.Applet;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.JFrame;

public class OpenFrames {
    private Hashtable index = new Hashtable();
    private static OpenFrames instance = null;
    private Applet applet = null;

    protected OpenFrames() {
    }

    public void addFrame(String title, JFrame f) {
        this.index.put(title, f);
    }

    public JFrame getFrame(String title) {
        if (this.index.containsKey(title)) {
            return (JFrame)this.index.get(title);
        }
        return null;
    }

    public static OpenFrames getInstance() {
        if (instance == null) {
            instance = new OpenFrames();
            return instance;
        }
        return instance;
    }

    public void removeFrame(String title) {
        this.index.remove(title);
    }

    public Applet getApplet() {
        return this.applet;
    }

    public void setApplet(Applet a) {
        this.applet = a;
    }

    public void show(AceObject o) {
        final String title = o.classe() + ": " + o.name();
        JFrame frame = null;
        frame = this.getFrame(title);
        if (frame == null) {
            ObjectViewController ovc = new ObjectViewController(o);
            frame = ovc.getObjectView();
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    JFrame f = (JFrame)e.getSource();
                    OpenFrames.this.removeFrame(title);
                    ((Component)f).setVisible(false);
                    f.dispose();
                }
            });
            frame.validate();
            this.addFrame(title, frame);
        } else {
            frame.setState(0);
            ((Component)frame).setVisible(true);
            frame.requestFocus();
            frame.validate();
        }
    }

    public boolean show(String url, String name) {
        if (this.applet == null) {
            return false;
        }
        try {
            URL u = new URL(url);
            this.getApplet().getAppletContext().showDocument(u, name);
            return true;
        }
        catch (Exception e) {
            System.err.println(e);
            return false;
        }
    }
}

