/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing;

import jade.db.AceAccessor;
import jade.db.AceObject;
import jadex.swing.classView.ClassView;
import jadex.swing.classView.TreeClassView;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.swing.JFrame;

public class ObjectViewController {
    private AceObject localObj = null;
    private Properties viewProp = null;

    public ObjectViewController() {
    }

    public ObjectViewController(AceObject obj) {
        this();
        this.setAceObject(obj);
    }

    public AceObject getAceObject() {
        return this.localObj;
    }

    public JFrame getObjectView() {
        JFrame jc = null;
        Class<?> c = null;
        String viewName = this.checkProperties();
        if (viewName != null && viewName.length() != 0) {
            try {
                c = Class.forName(viewName);
                ClassView view = (ClassView)c.newInstance();
                view.setObject(this.localObj);
                return view.getViewFrame();
            }
            catch (Exception e) {
                System.out.println("getObjectView() in ObjectViewController: " + e);
            }
        }
        jc = new TreeClassView(this.localObj).getViewFrame();
        return jc;
    }

    private String checkProperties() {
        String rtn = null;
        this.viewProp = new Properties();
        String name = "jadex" + File.separator + "view.prop";
        try {
            FileInputStream fis = new FileInputStream(new File(name));
            this.viewProp.load(fis);
        }
        catch (Exception e) {
            return null;
        }
        rtn = this.viewProp.getProperty(this.localObj.classe, null);
        return rtn;
    }

    public void setAceObject(AceObject obj) {
        try {
            AceAccessor accessor = (AceAccessor)obj.accessor();
            this.localObj = accessor.fetch(obj.classe(), obj.name());
        }
        catch (Exception e) {
            System.out.println("Error in fetching the AceObject");
        }
    }
}

