/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IndexSelector
extends JPanel {
    private JLabel[] index;
    private GridLayout ivjIndexSelectorGridLayout = null;

    public IndexSelector() {
        this.initialize();
    }

    public void addMouseListener(int n, MouseListener mouseListener) {
        if (this.index[n] != null) {
            this.index[n].addMouseListener(mouseListener);
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (this.index != null) {
            int n = 0;
            while (n < this.index.length) {
                this.index[n].addMouseListener(mouseListener);
                ++n;
            }
        }
    }

    private void draw() {
        this.removeAll();
        this.add(new JLabel());
        int n = 0;
        while (n < this.index.length) {
            this.add(this.index[n]);
            ++n;
        }
        this.add(new JLabel());
    }

    public JLabel[] getIndex() {
        if (this.index != null) {
            return this.index;
        }
        return null;
    }

    public JLabel getIndex(int n) {
        return this.index[n];
    }

    private GridLayout getIndexSelectorGridLayout() {
        GridLayout gridLayout = null;
        try {
            gridLayout = new GridLayout();
            gridLayout.setVgap(2);
            gridLayout.setHgap(2);
            gridLayout.setColumns(28);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return gridLayout;
    }

    private void handleException(Throwable throwable) {
    }

    private void initLabels() {
        int n = 0;
        if (this.index == null) {
            this.index = new JLabel[26];
            char c = 'A';
            while (c <= 'Z') {
                this.index[n] = new JLabel(String.valueOf(c));
                this.index[n].setFont(new Font("Monospaced", 1, 12));
                this.index[n].invalidate();
                ++n;
                c = (char)(c + '\u0001');
            }
        }
        this.draw();
    }

    private void initialize() {
        this.setName("IndexSelector");
        this.setPreferredSize(new Dimension(523, 28));
        this.setLayout(this.getIndexSelectorGridLayout());
        this.initLabels();
    }

    public static void main(String[] stringArray) {
        try {
            JFrame jFrame = new JFrame();
            jFrame.setTitle("Index Selector");
            IndexSelector indexSelector = new IndexSelector();
            jFrame.getContentPane().add((Component)indexSelector, "Center");
            ((Component)jFrame).setSize(530, 100);
            ((Component)jFrame).setVisible(true);
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
        }
        catch (Throwable throwable) {}
    }

    public void removeMouseListener(int n, MouseListener mouseListener) {
        if (this.index[n] != null) {
            this.index[n].removeMouseListener(mouseListener);
        }
    }

    public void removeMouseListener(MouseListener mouseListener) {
        if (this.index != null) {
            int n = 0;
            while (n < this.index.length) {
                this.index[n].removeMouseListener(mouseListener);
                ++n;
            }
        }
    }

    public void setIndex(int n, JLabel jLabel) {
        this.index[n] = jLabel;
        this.draw();
    }

    public void setIndex(JLabel[] jLabelArray) {
        if (jLabelArray.length == this.index.length) {
            int n = 0;
            while (n < this.index.length) {
                this.index[n] = jLabelArray[n];
                ++n;
            }
        }
        this.draw();
    }
}

