/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing;

import jade.db.AceObject;
import jade.db.JSAceAccessor;
import jadex.swing.classView.MapView;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class GeneticMapApplet
extends JApplet {
    private String aceobject = null;
    private String host = null;
    private int port;
    private String cls = null;
    private String obj = null;
    private JButton jButton1;
    private JLabel jLabel1;

    public void init() {
        this.aceobject = this.getParameter("aceobject");
        this.host = this.getParameter("host");
        String p = this.getParameter("port");
        if (p != null) {
            this.port = Integer.parseInt(p);
        }
        if (this.host == null) {
            this.host = "formaggio.cshl.org";
            this.port = 1881;
        }
        if (this.aceobject == null) {
            this.aceobject = new String("I");
        }
        this.obj = this.getParameter("obj_name");
        this.cls = this.getParameter("obj_class");
        this.initComponents();
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.jButton1.setText("Show Genetic Map");
        this.jButton1.setFont(new Font("Dialog", 0, 12));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GeneticMapApplet.this.jButton1ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        this.getContentPane().add((Component)this.jButton1, gridBagConstraints1);
        this.jLabel1.setText("Click this button to launch the applet...");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(0, 0, 15, 0);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints1);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.jLabel1.setText("Applet Loading: GeneticMap " + this.aceobject);
        this.jButton1.setEnabled(false);
        try {
            JSAceAccessor accessor = new JSAceAccessor(this.host, this.port);
            AceObject map = accessor.fetch("map", this.aceobject);
            if (map == null) {
                this.jLabel1.setText("Sorry, " + this.aceobject + " cannot be found in this AceDB.");
                return;
            }
            MapView view = new MapView(map, this);
            if (this.obj != null && this.cls != null) {
                view.search(this.cls, this.obj);
            }
            this.jLabel1.setText("Loading finished: GeneticMap " + map.name());
        }
        catch (Exception e) {
            System.err.println(e);
            this.jLabel1.setText("Sorry, cannot get " + this.aceobject + ". " + "Reload please.");
        }
    }

    public void setMessage(String s) {
        this.jLabel1.setText(s);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Applet Test");
        GeneticMapApplet applet = new GeneticMapApplet();
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.getContentPane().add((Component)applet, "Center");
        ((Component)f).setSize(300, 200);
        ((Component)f).setVisible(true);
    }
}

