/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing;

import jade.db.AceAccessor;
import jade.db.AceAccessorFacade;
import jade.db.AceObject;
import jadex.swing.ClassDisplayerModel;
import jadex.swing.ObjectLabel;
import jadex.swing.WelcomePane;
import java.awt.Color;
import java.awt.GridLayout;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ClassListModel {
    private String name;
    private PropertyChangeSupport propertyChange;
    private AceAccessor accessor = null;
    private AceAccessorFacade facade = null;
    private JLabel startingLabel = null;
    private Vector letterList = new Vector();
    private JPanel fieldCurrentPanel = new JPanel();
    private Thread queryThread = new Thread();
    private Vector list = null;

    public ClassListModel() {
    }

    public ClassListModel(AceAccessor accessor, JLabel label, ClassDisplayerModel classModel) {
        this.accessor = accessor;
        this.facade = new AceAccessorFacade(accessor);
        this.startingLabel = label;
        this.setClassName(classModel.getClassName());
        this.setLetterList(classModel.getLabelAll(), classModel.getLabels());
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChange().addPropertyChangeListener(listener);
    }

    public void fetchObjects(String letter, int start, int length) {
        String pattern = null;
        pattern = letter.equalsIgnoreCase("Total") ? "*" : letter;
        final String query = "find " + this.getClassName() + " " + pattern;
        final int localStart = start;
        final int localLength = length;
        this.queryThread = new Thread(new Runnable(){

            @Override
            public void run() {
                WelcomePane information = new WelcomePane();
                information.setMessage("Downloading data from AceDB...");
                ClassListModel.this.setCurrentPanel(information);
                Thread.yield();
                AceObject[] objects = null;
                try {
                    objects = ClassListModel.this.facade.getAceObjects(query, localStart, localLength);
                    information.setMessage("Downloading finished.");
                    information.repaint();
                    Thread.yield();
                    ClassListModel.this.list = new Vector();
                    int i = 0;
                    while (i < objects.length) {
                        ClassListModel.this.list.addElement(objects[i]);
                        ++i;
                    }
                    ClassListModel.this.setList(ClassListModel.this.list);
                }
                catch (Throwable t) {
                    information.setMessage("Downloading failed. Try again.");
                    return;
                }
            }
        });
        this.queryThread.start();
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
    }

    public AceAccessor getAceAccessor() {
        return this.accessor;
    }

    public String getClassName() {
        return this.name;
    }

    public JPanel getCurrentPanel() {
        return this.fieldCurrentPanel;
    }

    public Vector getLetterList() {
        return this.letterList;
    }

    protected PropertyChangeSupport getPropertyChange() {
        if (this.propertyChange == null) {
            this.propertyChange = new PropertyChangeSupport(this);
        }
        return this.propertyChange;
    }

    public JLabel getStartingLabel() {
        return this.startingLabel;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChange().removePropertyChangeListener(listener);
    }

    public void setAceAccessor(AceAccessor model) {
        if (this.accessor == null) {
            this.accessor = model;
        }
    }

    public void setClassName(String name) {
        this.name = name;
    }

    public void setCurrentPanel(JPanel currentPanel) {
        JPanel oldValue = this.fieldCurrentPanel;
        this.fieldCurrentPanel = currentPanel;
        this.firePropertyChange("currentPanel", oldValue, currentPanel);
    }

    public void setLetterList(JLabel[] letter) {
        int i = 0;
        while (i < letter.length) {
            if (letter[i].getToolTipText() != null) {
                this.letterList.addElement(letter[i].getToolTipText());
            }
            ++i;
        }
    }

    public void setLetterList(JLabel labelAll, JLabel[] letter) {
        this.letterList.addElement(labelAll.getToolTipText());
        int i = 0;
        while (i < letter.length) {
            if (letter[i].getToolTipText() != null) {
                this.letterList.addElement(letter[i].getToolTipText());
            }
            ++i;
        }
    }

    public void setLetterList(Vector letter) {
        this.letterList = letter;
    }

    private void setList(Vector list) {
        JPanel listPanel = new JPanel();
        int total = list.size();
        int row = (int)((double)total / 10.0 + 0.9);
        GridLayout grid = new GridLayout(row, 10, 3, 1);
        listPanel.setLayout(grid);
        int i = 0;
        while (i < total) {
            AceObject obj = (AceObject)list.elementAt(i);
            ObjectLabel label = new ObjectLabel(obj);
            label.setForeground(Color.blue);
            listPanel.add(label);
            ++i;
        }
        this.setCurrentPanel(listPanel);
    }

    public void setStartingLabel(JLabel label) {
        this.startingLabel = label;
    }
}

