/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing;

import jadex.swing.ClassListMediator;
import jadex.swing.ClassListModel;
import jadex.swing.WelcomePane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;

public class ClassListDisplayer
extends JPanel
implements PropertyChangeListener {
    private JToolBar ivjJToolBar1 = null;
    private JPanel ivjJPanel3 = null;
    private GridLayout ivjJPanel3GridLayout = null;
    private JPanel ivjJPanel1 = null;
    private GridLayout ivjJPanel1GridLayout = null;
    private ClassListModel model = null;
    private JButton ivjAllButton = null;
    private JComboBox ivjLetterBox = null;
    private JLabel ivjLetterLabel = null;
    private JButton ivjNextButton = null;
    private JComboBox ivjPageBox = null;
    private JLabel ivjPageLabel = null;
    private JButton ivjPreviouseButton = null;
    private String className = null;
    private ClassListMediator mediator = null;
    public static final int TOTAL_LIST_NUMBER = 500;
    private ClassListModel ivjModel = null;
    private JPanel ivjJPanel2 = null;
    private int totalPage;
    private JPanel currentPanel = null;
    private JPanel ivjJPanel4 = null;

    public ClassListDisplayer() {
        this.initialize();
    }

    public ClassListDisplayer(ClassListModel model) {
        this.setModel(model);
    }

    protected void checkGUI(int page) {
        int totalPage;
        this.getPreviouseButton().setEnabled(false);
        this.getNextButton().setEnabled(false);
        this.getAllButton().setEnabled(true);
        this.getPageBox().setEnabled(true);
        this.getLetterBox().setEnabled(true);
        if (this.getLetterBox().getSelectedIndex() == 0) {
            this.getAllButton().setEnabled(false);
        }
        if ((totalPage = this.getTotalPage()) > 1) {
            if (page > 1 && page < totalPage) {
                this.getPreviouseButton().setEnabled(true);
                this.getNextButton().setEnabled(true);
            } else if (page == 1) {
                this.getPreviouseButton().setEnabled(false);
                this.getNextButton().setEnabled(true);
            } else if (page == totalPage) {
                this.getPreviouseButton().setEnabled(true);
                this.getNextButton().setEnabled(false);
            }
        }
    }

    private void connEtoC1(PropertyChangeEvent arg1) {
        try {
            this.setPanel(this.getModel().getCurrentPanel());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void disableGUI() {
        this.getPreviouseButton().setEnabled(false);
        this.getNextButton().setEnabled(false);
        this.getAllButton().setEnabled(false);
        this.getPageBox().setEnabled(false);
        this.getLetterBox().setEnabled(false);
    }

    protected JButton getAllButton() {
        if (this.ivjAllButton == null) {
            try {
                this.ivjAllButton = new JButton();
                this.ivjAllButton.setName("AllButton");
                this.ivjAllButton.setToolTipText("List All Entries");
                this.ivjAllButton.setText("All...");
                this.ivjAllButton.setMaximumSize(new Dimension(37, 39));
                this.ivjAllButton.setHorizontalTextPosition(0);
                this.ivjAllButton.setVerticalTextPosition(3);
                this.ivjAllButton.setPreferredSize(new Dimension(37, 39));
                this.ivjAllButton.setMargin(new Insets(0, 0, 0, 0));
                this.ivjAllButton.setMinimumSize(new Dimension(37, 39));
                this.ivjAllButton.setEnabled(false);
                this.ivjAllButton.addActionListener(this.mediator);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAllButton;
    }

    public JPanel getCurrentPanel() {
        return this.currentPanel;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setToolTipText("List by Specified Leading Letter");
                this.ivjJPanel1.setLayout(this.getJPanel1GridLayout());
                this.ivjJPanel1.setMaximumSize(new Dimension(120, 39));
                this.ivjJPanel1.setPreferredSize(new Dimension(120, 39));
                this.ivjJPanel1.setEnabled(true);
                this.ivjJPanel1.setMinimumSize(new Dimension(120, 39));
                this.getJPanel1().add((Component)this.getLetterLabel(), this.getLetterLabel().getName());
                this.getJPanel1().add((Component)this.getLetterBox(), this.getLetterBox().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private GridLayout getJPanel1GridLayout() {
        GridLayout ivjJPanel1GridLayout = null;
        try {
            ivjJPanel1GridLayout = new GridLayout();
            ivjJPanel1GridLayout.setRows(2);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjJPanel1GridLayout;
    }

    private JPanel getJPanel2() {
        if (this.ivjJPanel2 == null) {
            try {
                this.ivjJPanel2 = new JPanel();
                this.ivjJPanel2.setName("JPanel2");
                this.ivjJPanel2.setLayout(new BorderLayout());
                this.getJPanel2().add((Component)this.getJPanel4(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel2;
    }

    private JPanel getJPanel3() {
        if (this.ivjJPanel3 == null) {
            try {
                this.ivjJPanel3 = new JPanel();
                this.ivjJPanel3.setName("JPanel3");
                this.ivjJPanel3.setToolTipText("List Page By Page");
                this.ivjJPanel3.setLayout(this.getJPanel3GridLayout());
                this.ivjJPanel3.setMaximumSize(new Dimension(65, 39));
                this.ivjJPanel3.setPreferredSize(new Dimension(65, 39));
                this.ivjJPanel3.setEnabled(true);
                this.ivjJPanel3.setMinimumSize(new Dimension(65, 39));
                this.getJPanel3().add((Component)this.getPageLabel(), this.getPageLabel().getName());
                this.getJPanel3().add((Component)this.getPageBox(), this.getPageBox().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel3;
    }

    private GridLayout getJPanel3GridLayout() {
        GridLayout ivjJPanel3GridLayout = null;
        try {
            ivjJPanel3GridLayout = new GridLayout();
            ivjJPanel3GridLayout.setRows(2);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjJPanel3GridLayout;
    }

    private JPanel getJPanel4() {
        if (this.ivjJPanel4 == null) {
            try {
                this.ivjJPanel4 = new JPanel();
                this.ivjJPanel4.setName("JPanel4");
                this.ivjJPanel4.setLayout(null);
                this.ivjJPanel4.setBorder(new EtchedBorder());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel4;
    }

    private JToolBar getJToolBar1() {
        if (this.ivjJToolBar1 == null) {
            try {
                this.ivjJToolBar1 = new JToolBar();
                this.ivjJToolBar1.setName("JToolBar1");
                this.ivjJToolBar1.setPreferredSize(new Dimension(338, 45));
                this.ivjJToolBar1.setMaximumSize(new Dimension(338, 45));
                this.ivjJToolBar1.setMinimumSize(new Dimension(338, 45));
                this.getJToolBar1().add((Component)this.getPreviouseButton(), this.getPreviouseButton().getName());
                this.getJToolBar1().add((Component)this.getNextButton(), this.getNextButton().getName());
                this.getJToolBar1().add((Component)this.getAllButton(), this.getAllButton().getName());
                this.ivjJToolBar1.addSeparator();
                this.ivjJToolBar1.add(this.getJPanel3());
                this.ivjJToolBar1.addSeparator();
                this.ivjJToolBar1.add(this.getJPanel1());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBar1;
    }

    protected JComboBox getLetterBox() {
        if (this.ivjLetterBox == null) {
            try {
                this.ivjLetterBox = new JComboBox();
                this.ivjLetterBox.setName("LetterBox");
                this.ivjLetterBox.setEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLetterBox;
    }

    protected JLabel getLetterLabel() {
        if (this.ivjLetterLabel == null) {
            try {
                this.ivjLetterLabel = new JLabel();
                this.ivjLetterLabel.setName("LetterLabel");
                this.ivjLetterLabel.setText("Letter List");
                this.ivjLetterLabel.setForeground(Color.black);
                this.ivjLetterLabel.setEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLetterLabel;
    }

    public ClassListModel getModel() {
        return this.ivjModel;
    }

    public String getName() {
        return this.className;
    }

    protected JButton getNextButton() {
        if (this.ivjNextButton == null) {
            try {
                this.ivjNextButton = new JButton();
                this.ivjNextButton.setName("NextButton");
                this.ivjNextButton.setToolTipText("Next Page");
                this.ivjNextButton.setText("");
                this.ivjNextButton.setHorizontalTextPosition(0);
                this.ivjNextButton.setActionCommand("next");
                this.ivjNextButton.setVerticalTextPosition(3);
                this.ivjNextButton.setIcon(new ImageIcon("jadex/swing/next.gif"));
                this.ivjNextButton.setMargin(new Insets(0, 0, 0, 0));
                this.ivjNextButton.setEnabled(false);
                this.ivjNextButton.addActionListener(this.mediator);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjNextButton;
    }

    protected JComboBox getPageBox() {
        if (this.ivjPageBox == null) {
            try {
                this.ivjPageBox = new JComboBox();
                this.ivjPageBox.setName("PageBox");
                this.ivjPageBox.setEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPageBox;
    }

    private JLabel getPageLabel() {
        if (this.ivjPageLabel == null) {
            try {
                this.ivjPageLabel = new JLabel();
                this.ivjPageLabel.setName("PageLabel");
                this.ivjPageLabel.setText("Page List");
                this.ivjPageLabel.setForeground(Color.black);
                this.ivjPageLabel.setEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPageLabel;
    }

    protected JButton getPreviouseButton() {
        if (this.ivjPreviouseButton == null) {
            try {
                this.ivjPreviouseButton = new JButton();
                this.ivjPreviouseButton.setName("PreviouseButton");
                this.ivjPreviouseButton.setToolTipText("Previouse Page");
                this.ivjPreviouseButton.setText("");
                this.ivjPreviouseButton.setHorizontalTextPosition(0);
                this.ivjPreviouseButton.setActionCommand("previous");
                this.ivjPreviouseButton.setVerticalTextPosition(3);
                this.ivjPreviouseButton.setIcon(new ImageIcon("jadex/swing/prev.gif"));
                this.ivjPreviouseButton.setMargin(new Insets(0, 0, 0, 0));
                this.ivjPreviouseButton.setEnabled(false);
                this.ivjPreviouseButton.addActionListener(this.mediator);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPreviouseButton;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() {
    }

    private void initialize() {
        this.mediator = new ClassListMediator();
        this.setName("ClassListDisplayer1");
        this.setLayout(new BorderLayout());
        this.setSize(371, 186);
        this.add((Component)this.getJToolBar1(), "North");
        this.add((Component)this.getJPanel2(), "Center");
        this.initConnections();
        this.setBorder(new EtchedBorder());
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame("ClassListDisplayer");
            ClassListDisplayer aClassListDisplayer1 = new ClassListDisplayer();
            frame.getContentPane().add("Center", aClassListDisplayer1);
            ((Component)frame).setSize(aClassListDisplayer1.getSize());
            ((Component)frame).setVisible(true);
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JPanel");
            exception.printStackTrace(System.out);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.getModel() && evt.getPropertyName().equals("currentPanel")) {
            this.connEtoC1(evt);
        }
    }

    public void setModel(ClassListModel model) {
        this.initialize();
        ClassListModel localModel = model;
        this.setName(localModel.getClassName());
        JLabel starting = localModel.getStartingLabel();
        String firstItem = starting.getToolTipText();
        Vector list = localModel.getLetterList();
        int i = 0;
        while (i < list.size()) {
            this.getLetterBox().addItem(list.elementAt(i));
            ++i;
        }
        this.ivjModel = localModel;
        this.ivjModel.addPropertyChangeListener(this);
        this.mediator.setDisplayer(this);
        this.mediator.setModel(localModel);
        this.getPageBox().addItemListener(this.mediator);
        this.getLetterBox().addItemListener(this.mediator);
        if (firstItem.equals(list.elementAt(0))) {
            this.mediator.itemStateChanged(new ItemEvent(this.getLetterBox(), 0, firstItem, 1));
            return;
        }
        this.getAllButton().setEnabled(true);
        this.getLetterBox().setSelectedItem(firstItem);
    }

    public void setName(String name) {
        this.className = name;
    }

    protected void setPageBox(int total) {
        this.totalPage = (total + 499) / 500;
        JComboBox cb = this.getPageBox();
        cb.removeAllItems();
        int i = 1;
        while (i <= this.totalPage) {
            cb.addItem(i + "");
            ++i;
        }
    }

    public void setPanel(JPanel arg1) {
        this.getJPanel2().removeAll();
        this.getJPanel2().add((Component)new JScrollPane(arg1), "Center");
        this.getJPanel2().revalidate();
        if (arg1 instanceof WelcomePane) {
            this.disableGUI();
        } else {
            this.checkGUI(this.mediator.getSelectedPage());
        }
    }
}

