/*
 * Decompiled with CFR 0.152.
 */
package jadeSocket;

import jade.db.AceAccessor;
import jadeSocket.JSControl;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class JSAceServer {
    private ServerSocket ss = null;
    private String host = null;
    private int port;
    private final int SERVER_PORT = 40000;
    private boolean debug = false;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java JSAceServer host port");
            System.exit(0);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        new JSAceServer(host, port);
    }

    public JSAceServer(String host, int port) {
        this.host = host;
        this.port = port;
        try {
            this.ss = new ServerSocket(40000);
            if (this.debug) {
                System.out.println("JSAceServer is listening...");
            }
            while (true) {
                Socket s = this.ss.accept();
                JadeThread t = new JadeThread(s);
                t.start();
                if (!this.debug) continue;
                System.out.println("Get Connected from jade client.");
            }
        }
        catch (IOException e) {
            System.out.println("JSAceServer Constructor: " + e);
            return;
        }
    }

    class JadeThread
    extends Thread {
        private Socket s = null;
        private LineNumberReader lnr = null;
        private PrintWriter pw = null;
        private JSControl control = null;

        JadeThread(Socket s) {
            this.s = s;
            try {
                this.lnr = new LineNumberReader(new BufferedReader(new InputStreamReader(s.getInputStream())));
                this.pw = new PrintWriter(new OutputStreamWriter(s.getOutputStream()));
            }
            catch (IOException e) {
                System.out.println(e);
            }
            this.control = new JSControl(JSAceServer.this.host, JSAceServer.this.port);
            this.control.initializeRequest("guest", "guest");
            this.send(AceAccessor.OK + " hello");
        }

        private void send(String s) {
            char[] sb = s.toCharArray();
            int length = sb.length;
            this.pw.println(length);
            if (JSAceServer.this.debug) {
                System.out.println("Length in JSAceServer: " + length);
            }
            this.pw.write(sb, 0, length);
            this.pw.flush();
        }

        private String digest(String s) {
            Object rtnString = null;
            StringBuffer buffer = new StringBuffer();
            LineNumberReader lnr = new LineNumberReader(new CharArrayReader(s.toCharArray()));
            String line = null;
            try {
                while ((line = lnr.readLine()) != null) {
                    int pos = line.indexOf("//");
                    if (pos != -1) {
                        int pos1 = line.indexOf("Active Object");
                        if (pos1 != -1) {
                            String numberS = line.substring(pos + 2, pos1).trim();
                            buffer.insert(0, numberS + " ");
                        }
                        line = line.substring(0, pos);
                    }
                    line = line + "\r\n";
                    buffer.append(line);
                }
            }
            catch (IOException e) {
                System.out.println(e);
            }
            return buffer.toString();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                String query;
                do {
                    query = this.lnr.readLine();
                    if (JSAceServer.this.debug) {
                        System.out.println(query);
                    }
                    if (query.length() == 4) {
                        query = query + " ";
                    }
                    if (query.indexOf("list") != -1 || query.indexOf("show") != -1) {
                        query = query + " -j";
                    }
                    this.control.request(query);
                    String result = this.control.getMessage();
                    result = this.digest(result);
                    result = AceAccessor.OK + " " + result;
                    this.send(result);
                    this.send(".");
                } while (!query.endsWith("quit"));
            }
            catch (IOException e) {
                System.out.println(e);
            }
            try {
                this.lnr.close();
                this.s.close();
                if (!JSAceServer.this.debug) return;
                System.out.println("Client closed.");
                return;
            }
            catch (IOException e) {
                System.out.println("Thread: " + e);
            }
        }
    }
}

